%define ver_major 4.2
%define beta %nil
%define xdg_name org.gnome.Zenity

%def_enable webkitgtk
%def_enable man
%def_enable check

Name: zenity
Version: %ver_major.1
Release: alt1%beta

Summary: The GNOME port of dialog(1)
License: LGPL-2.1-or-later
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Projects/Zenity

Vcs: https://gitlab.gnome.org/GNOME/zenity.git

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz

%define adw_ver 1.2
%define webkit_api_ver 6.0

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson yelp-tools
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
%{?_enable_webkitgtk:BuildRequires: pkgconfig(webkitgtk-%webkit_api_ver)}
%{?_enable_man:BuildRequires: help2man}
%{?_enable_check:BuildRequires:desktop-file-utils}

%description
This is Zenity: the GNOME port of the venerable 'dialog' program,
which allows you to display dialog boxes from the command-line
and shell scripts.

%prep
%setup -n %name-%version%beta

%build
%meson \
	%{?_enable_webkitgtk:-Dwebkitgtk=true}
	%{?_disable_man:-Dmanpage=false}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/%name.png
%{?_enable_man:%_man1dir/*}
%doc AUTHORS NEWS README*

%changelog
