%define _unpackaged_files_terminate_build 1

Name: yodl
Epoch: 1
Version: 4.04.00
Release: alt1
Summary: Yet oneOther Document Language
License: GPL
Group: Text tools
URL: https://gitlab.com/fbb-git/yodl

# https://gitlab.com/fbb-git/yodl.git
Source: yodl-%version.tar

Patch1: yodl-alt-build.patch

# Automatically added by buildreq on Sun Apr 13 2008
BuildRequires: flex groff-base netpbm python-modules
BuildRequires: gcc-c++
BuildRequires: boost-filesystem-devel

BuildPreReq: icmake texlive-collection-latexrecommended tex(epsf.sty) ghostscript-utils

%description
Yodl is a package that implements a pre-document language and tools to
process it.  The idea of Yodl is that you write up a document in a
pre-language, then use the tools (eg. yodl2html) to convert it to some
final document language.  Current converters are for HTML, ms, man, LaTeX
SGML and texinfo, plus a poor-man's text converter.  Main document types
are "article", "report", "book" and "manpage".  The Yodl document
language is designed to be easy to use and extensible.

%package docs
Summary: Documentation for Yodl
Group: Documentation
BuildArch: noarch

%description docs
Yodl is a package that implements a pre-document language and tools to
process it.  The idea of Yodl is that you write up a document in a
pre-language, then use the tools (eg. yodl2html) to convert it to some
final document language.  Current converters are for HTML, ms, man, LaTeX
SGML and texinfo, plus a poor-man's text converter.  Main document types
are "article", "report", "book" and "manpage".  The Yodl document
language is designed to be easy to use and extensible.

This package contais documentation for Yodl.

%prep
%setup
%autopatch1 -p2

%build
%add_optflags -std=c++17
export ac_cv_lib_intl_gettext=no
for i in programs macros man manual
do
	./build $i
done

%install
for i in programs macros man manual docs
do
	./build install $i %buildroot
done

# remove brocken symlinks
find %buildroot%_man1dir/ -xtype l 2>/dev/null -exec rm {} \;

%files
%_bindir/*
%_datadir/%name
%_mandir/man?/*

%files docs
%_docdir/%name
%_docdir/yodl-doc

%changelog
