# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

%define xterm_stdflags \\\
	--with-app-defaults=%_sysconfdir/X11/app-defaults \\\
	--with-utempter \\\
	--enable-warnings \\\
	--enable-wide-chars \\\
	--enable-dec-locator \\\
	--enable-narrowproto \\\
	--disable-full-tgetent \\\
	--disable-echo \\\
	--enable-256-color \\\
	--enable-doublechars \\\
	--with-icondir=%_iconsdir

%define xterm_expflags \\\
  --with-neXtaw          \\\
  --enable-dabbrev       \\\
  --enable-double-buffer \\\
  --enable-exec-xterm    \\\
  --enable-load-vt-fonts \\\
  --enable-logfile-exec  \\\
  --enable-logging       \\\
  --enable-readline-mouse\\\
  --enable-regis-graphics\\\
  --with-terminal-id=vt340\\\
  --with-terminal-type=xterm-256color\\\
  --enable-toolbar

Name: xterm
Version: 403
Release: alt1

Summary: A standard terminal emulator for the X Window System
Summary(ru_RU.UTF8): Стандартный эмулятор терминала для X Window System
Url: http://invisible-island.net/xterm/
License: MIT
Group: Terminals

Source0: ftp://invisible-island.net/%name/%name-%version.tgz
Source1: uxterm

Patch0001: 0001-xterm-alt-render.patch
Patch0002: 0002-xterm-alt-utempter.patch
Patch0003: 0003-xterm-alt-perms.patch
Patch0004: 0004-xterm-alt-deffont.patch
Patch0005: 0005-xterm-alt-makefile-install.patch
Patch0006: 0006-xterm-alt-disable-report_win_label.patch
Patch0007: 0007-xterm-alt-i18n.patch
Patch0008: 0008-xterm-alt-colors.patch
Patch0009: 0009-xterm-alt-appdef.patch
Patch0010: 0010-xterm-alt-translate-update-desktop.patch

Provides: xvt, %_bindir/xvt, x-terminal-emulator %_bindir/x-terminal-emulator
Requires(pre): libutempter >= 1.0.7, alternatives >= 0.3.5-alt1
BuildRequires(pre): alternatives groff-base imake libXaw-devel libXft-devel libncurses-devel libutempter-devel libxkbfile-devel xorg-cf-files
# Automatically added by buildreq on Wed Nov 14 2012
# optimized out: alternatives fontconfig fontconfig-devel gnu-config libICE-devel libSM-devel libX11-devel libXmu-devel libXrender-devel libXt-devel libfreetype-devel libtinfo-devel pkg-config xorg-kbproto-devel xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: ctags groff-base imake libXaw-devel libXext-devel libXft-devel libncurses-devel libneXtaw-devel libutempter-devel libxkbfile-devel xorg-cf-files

Requires: /etc/X11/app-defaults, resize = %EVR

%description
The XTerm program is the standard terminal emulator for the X Window System.
It provides DEC VT102/VT220 and Tektronix 4014 compatible terminals for
programs that can't use the window system directly.  If the underlying
operating system supports terminal resizing capabilities (for example,
the SIGWINCH signal in systems derived from 4.3bsd), xterm will use
the facilities to notify programs running in the window whenever it
is resized.

%package experimental
Group: Terminals
Summary: experimental version of xterm
Requires: /etc/X11/app-defaults
%description experimental
XTerm build with some experimental/unsafe features:
%xterm_expflags

%package -n resize
Group: Terminals
Summary: Set environment and terminal settings to current xterm window size
Provides: %name-resize = %EVR
Obsoletes: %name-resize < %EVR
%description -n resize
Resize prints a shell command for setting the appropriate environment
variables to indicate the current size of xterm window from which the
command is run.

%prep
%setup

install -pm755 %_sourcedir/uxterm .

%patch0001 -p2
%patch0002 -p2
%patch0003 -p2
%patch0004 -p2
%patch0005 -p2
%patch0006 -p2
%patch0007 -p2
%patch0008 -p2
%patch0009 -p2
%patch0010 -p2

sed -i 's|^Exec=xterm|& -name XTerm|' %name.desktop
sed -i 's|_48x48||' *.desktop
sed -i '/^Comment=/s/$/ (UTF8 forced)/' uxterm.desktop

# Remove deprecated Encoding key
sed -i '/^Encoding=/d' *.desktop

%build
export ac_cv_path_XTERM_PATH=%_bindir/%name
# Rebuild this
touch ctlseqs.ms

%configure %xterm_stdflags
%make_build all ctlseqs.txt
cp xterm xterm.std
xz ctlseqs.txt

make distclean
%configure %xterm_stdflags %xterm_expflags
%make_build
cp xterm xterm.extd
cp xterm.std xterm

%install
%makeinstall_std
install xterm.extd %buildroot%_bindir/XTerm
install -D %name.desktop %buildroot/%_desktopdir/%name.desktop

for n in xterm xterm-color; do
  for s in 48 32; do
    install -D icons/${n}_${s}x${s}.xpm %buildroot%_iconsdir/hicolor/${s}x${s}/apps/$n.xpm
  done
  install -D icons/%name.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
done

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/xterm	40
%_bindir/x-terminal-emulator	%_bindir/xterm	40
EOF

%files
%doc README ctlseqs.txt.* %name.log.html tektests vttests
%attr(2711,root,utempter) %_bindir/%name
%_bindir/uxterm
%_bindir/koi8rxterm
%_man1dir/%name.1.*
%_man1dir/uxterm.1.*
%_man1dir/koi8rxterm.1.*
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%_altdir/%name
%_desktopdir/*.desktop
%_pixmapsdir/*.xpm
%_iconsdir/hicolor/*/apps/xterm*

%files -n resize
%_bindir/resize
%_man1dir/resize.1.*

%files experimental
%attr(2711,root,utempter) %_bindir/XTerm

%changelog
