%define _unpackaged_files_terminate_build 1

Name: xsp
Url: https://www.mono-project.com
License: X11/MIT
Group: System/Servers
Version: 4.7.1
Release: alt1
Summary: Small Web Server Hosting ASP.NET

# https://github.com/mono/xsp.git
Source: %name-%version.tar

Patch1: xsp-alt-build.patch

BuildRequires(pre): rpm-build-mono
BuildRequires: sqlite3 mono-full mono-devel-full pkg-config /proc

%define xspConfigsLocation %_sysconfdir/xsp/4.0
%define xspAvailableApps %xspConfigsLocation/applications-available
%define xspEnabledApps %xspConfigsLocation/applications-enabled

Provides:  mono4-xsp = %EVR
Conflicts: mono4-xsp < %EVR
Obsoletes: mono4-xsp < %EVR

Provides: mono(fastcgi-mono-server4) = %{version}.0

%description
The XSP server is a small Web server that hosts the Mono System.Web
classes for running what is commonly known as ASP.NET.

%prep
%setup
%patch1 -p1

%build
NOCONFIGURE=yes sh ./autogen.sh
%configure
%make

%install
%makeinstall_std

rm -rf %buildroot%_libdir/xsp/unittests
rm -rf %buildroot%_libdir/xsp/test
rm -f %buildroot%_libdir/*.a

mkdir -p %buildroot/%xspAvailableApps
mkdir -p %buildroot/%xspEnabledApps
mkdir -p %buildroot%_logrotatedir
mkdir -p %buildroot%_runtimedir/xsp2
install -m 644 man/mono-asp-apps.1 %buildroot%_man1dir/mono-asp-apps.1
install -m 644 packaging/opensuse/xsp2.logrotate %buildroot%_logrotatedir/xsp2
install -m 755 tools/mono-asp-apps/mono-asp-apps %buildroot%_bindir/mono-asp-apps

%files
%config (noreplace) %_logrotatedir/*
%_bindir/*
%_libdir/*.so
%_libdir/*.so.*
%_pkgconfigdir/*
%_monodir/4.5/Mono.WebServer2.dll
%_monodir/4.5/fastcgi-mono-server4.exe
%_monodir/4.5/mod-mono-server4.exe
%_monodir/4.5/xsp4.exe
%_monodir/4.5/mono-fpm.exe
%_monogacdir/Mono.WebServer2
%_monogacdir/fastcgi-mono-server4
%_monogacdir/mod-mono-server4
%_monogacdir/xsp4
%_monodocdir/Mono.WebServer.*
%_monodocdir/Mono.FastCGI.*
%_monogacdir/mono-fpm
%_libexecdir/xs*
%_man1dir/*

%changelog
