%define git_version v1.250726.0

Name: xray-core
Version: 25.8.3
Release: alt1

Summary: Project X
License: MPL-2.0
Group: System/Servers

Url: https://xtls.github.io/
Packager: Nazarov Denis <nenderus@altlinux.org>

# https://github.com/XTLS/Xray-core/archive/v%version/Xray-core-%version.tar.gz
Source0: Xray-core-%version.tar
# go mod vendor
Source1: vendor.tar

Source2: xray.service
Source3: xray@.service

BuildRequires: golang
BuildRequires: python3

%description
Project X originates from XTLS protocol, providing a set of network tools such as Xray-core and REALITY.

%prep
%setup -n Xray-core-%version -a 1

%build
go build -o xray -trimpath -ldflags "-X github.com/xtls/xray-core/core.build=%git_version -s -w -buildid=" -v ./main

%install
%__mkdir_p %buildroot{%_bindir,%_unitdir}
%__install -Dp -m0755 xray %buildroot%_bindir/
%__install -Dp -m0644 %SOURCE2 %buildroot%_unitdir/
%__install -Dp -m0644 %SOURCE3 %buildroot%_unitdir/

%post
%post_systemd_postponed xray

%preun
%systemd_preun xray

%files
%doc CODE_OF_CONDUCT.md README.md
%_bindir/xray
%_unitdir/xray.service
%_unitdir/xray@.service

%changelog
