#set_verify_elf_method strict

Name: xosview2
Version: 2.3.4
Release: alt1
Summary: An X Window System utility for monitoring system resources
License: GPL-2.0 and BSD-4-Clause-UC
Group: Monitoring
Url: http://xosview.sourceforge.net/

# https://github.com/hills/xosview.git
Source: %name-%version.tar.gz
Source1: xosview16.png
Source2: xosview32.png
Source3: xosview48.png
#ExcludeArch: armh i586
BuildRequires: gcc-c++ libXpm-devel libX11-devel desktop-file-utils

%description
The %name utility displays a set of bar graphs which show the current
system state, including memory usage, CPU usage, system load, etc.
Xosview runs under the X Window System.

%prep
%setup

%build
%add_optflags -std=gnu++17
%configure

%make_build


cat > %{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=%name
GenericName=OS Resource Viewer
Comment=
Exec=xosview2
Icon=xosview2
Categories=Utility;System;Monitor;
Terminal=false
EOF

%install
mkdir -p %buildroot{%_bindir,%_man1dir,%_x11appconfdir}
%makeinstall_std


install -pD -m644 Xdefaults %buildroot%_x11appconfdir/XOsview2
install -pD -m644 %SOURCE1  %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE2  %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE3  %buildroot%_liconsdir/%name.png

desktop-file-install --dir %buildroot%_datadir/applications %{name}.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	%buildroot%_desktopdir/xosview2.desktop

%files
%doc COPYING* CHANGES doc/README.linux TODO
%config %_x11appconfdir/*
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/X11/app-defaults/XOsview2
%_liconsdir/*.png
%_niconsdir/*.png
%_miconsdir/*.png

%changelog
