%define optflags_lto %nil
%def_disable xvmc

Name: xorg-drv-intel
Version: 2.99.917
Release: alt1.20250321
Epoch: 8
Summary: Intel integrated graphics chipsets
License: MIT
Group: System/X11
Url: https://gitlab.freedesktop.org/xorg/driver/xf86-video-intel
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: XORG_ABI_VIDEODRV = %get_xorg_abi_videodrv
Requires: xorg-dri-intel

Source: %name-%version.tar
Patch: %name-%version-%release.patch

ExclusiveArch: %ix86 x86_64
BuildRequires(Pre): xorg-sdk
BuildRequires: libGL-devel libX11-devel libXext-devel libXvMC-devel libXcursor-devel libXdamage-devel libXinerama-devel
BuildRequires: libXrandr-devel libXtst-devel xorg-proto-devel libxshmfence-devel libXrender-devel libxcbutil-devel
BuildRequires: xorg-util-macros libXfixes-devel libudev-devel libXScrnSaver-devel libXcomposite-devel
BuildRequires: libXxf86vm-devel libXfont2-devel libXv-devel

%description
The xf86-video-intel module is an open-source 2D graphics driver for
the X Window System as implemented by X.org. It supports a variety of
Intel graphics chipsets including:

* i810/i810e/i810-dc100,i815,
* i830M,845G,852GM,855GM,865G,
* 915G/GM,945G/GM/GME,946GZ
* G/GM/GME/Q965,
* G/Q33,G/Q35,G41,G/Q43,G/GM/Q45
* PineView-M (Atom N400 series)
* PineView-D (Atom D400/D500 series)
* Intel(R) HD Graphics,
* Intel(R) Iris(TM) Graphics,
* Intel(R) Iris(TM) Pro Graphics.

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--libexecdir=%_prefix/libexec \
	--with-xorg-module-dir=%_x11modulesdir \
	--enable-kms-only \
	--with-default-dri=3 \
	%{subst_enable xvmc} \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot install

%files
%doc AUTHORS README NEWS
%_bindir/intel-virtual-output
%_x11modulesdir/drivers/*.so
%_prefix/libexec/xf86-video-intel-backlight-helper
%_datadir/polkit-1/actions/org.x.xf86-video-intel.backlight-helper.policy
%_man4dir/i*.4*
%if_enabled xvmc
%_libdir/*.so.*
%endif

%changelog
