%define git %nil

Name: xmoto
Version: 0.6.3
Release: alt1

Summary: A challenging 2D motocross platform game.
License: GPLv2
Group: Games/Arcade

Url: https://xmoto.org
Vcs: https://github.com/xmoto/xmoto.git
# https://github.com/%name/%name/archive/%version/%version.tar.gz
Source: %name-%version-src.tar

Patch0: %name-0.6.3-alt-system-ode.patch
Patch1: %name-0.6.3-alt-asian-font-path.patch

BuildRequires: gcc-c++ libSDL2-devel libSDL2_mixer-devel libjpeg-devel
BuildRequires: lua-devel libode-devel libpng-devel libstdc++-devel
BuildRequires: zlib-devel bzlib-devel libcurl-devel
BuildRequires: libSDL2_gfx-devel libsqlite3-devel libSDL2_ttf-devel
BuildRequires: libSDL2_net-devel
BuildRequires: libxdg-basedir-devel
BuildRequires(pre): rpm-build-fonts cmake ninja-build
BuildRequires: libxml2-devel libGLU-devel liblzma-devel
# chinese locale requires fonts-ttf-chinese-big5, JFI
Requires: fonts-ttf-dejavu, %name-data = %EVR

%description
XMoto is a challenging 2D motocross platform game, where physics play an
all important role in the gameplay. You need to control your bike to its
limit, if you want to have a chance finishing the more difficult of the
challenges.

%package data
Group: Games/Arcade
Summary: %name gamepack data
BuildArch: noarch

%description data
%summary

%prep
%setup
%autopatch -p3

%builD
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.12
%add_optflags -std=c++11
%endif
%cmake \
  -GNinja

ninja \
  -vvv \
  -j %__nprocs \
  -C %_cmake__builddir

%install
DESTDIR=%buildroot ninja -C %_cmake__builddir install

rm -rf %buildroot%_datadir/%name/Textures/Fonts/*.ttf
ln -sr %buildroot%_ttffontsdir/dejavu/DejaVuSans{,Mono}.ttf \
	%buildroot%_datadir/%name/Textures/Fonts/

%find_lang --output=%name.files %name

%files -f %name.files
%doc ChangeLog COPYING README.md
%_bindir/*
%_pixmapsdir/%name.png
%_datadir/applications/%name.desktop
%_man6dir/*

%files data
%_datadir/%name

%changelog
