Name: xkeyboard-config
Summary: XML-based XKB configuration registry
Version: 2.46
Release: alt1
Epoch: 1
License: X11/MIT
Group: System/X11
Url: https://www.freedesktop.org/wiki/Software/XKeyboardConfig/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: libX11 >= 1.4.3

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch
BuildRequires: meson intltool xkbcomp glib2-devel libX11-devel xorg-util-macros xsltproc

%description
Just XML stuff. Later hopefully will be part of Xorg

%package devel
Summary: XML-based XKB configuration registry development package
Group: Development/Other
Requires: %name = %version-%release

%description devel
XML-based XKB configuration registry development package

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dcompat-rules=true \
	-Dxorg-rules-symlinks=true
%meson_build -v

for d in compat geometry keycodes symbols types; do
	cd $d
	xkbcomp -lfhlpR -o $d.dir '*'
	cd ../
done

%install
%meson_install

rm -f %buildroot%_datadir/X11/xkb/compiled
rm -f %buildroot%_datadir/X11/xkb
cp -a %buildroot%_datadir/%name-2 %buildroot%_datadir/X11/xkb

%find_lang --output=%name.lang %name-2 %name

%pre
[ ! -d %_datadir/X11/xkb/symbols/pc ] || rm -fr %_datadir/X11/xkb/symbols/pc

%files -f %name.lang
%doc AUTHORS README.md COPYING
%doc docs/README.config docs/README.enhancing docs/README.symbols
%_datadir/X11/xkb
%_datadir/%name-2
%_man7dir/*.7*

%files devel
%_datadir/pkgconfig/*.pc

%changelog
