%undefine __cmake_in_source_build

Name: xiphos
Version: 4.3.2.14
Release: alt2
Summary: Bible study and research tool
Url: http://xiphos.org/
Group: Text tools
License: GPL-2.0
Source: https://github.com/crosswire/xiphos/releases/download/%version/%name-%version.tar.xz
Source44: %name.watch
Patch: xiphos-4.2.1-glibc.patch
#Patch1:         find_biblesync.patch
Patch2:         xiphos-glib.patch
Patch3:         find_biblesync.patch

Requires: sword yelp
Requires: libgtk4-gir libgtksourceview4-gir
Provides: gnomesword
Obsoletes: gnomesword

BuildRequires(pre): rpm-macros-cmake
BuildRequires(pre): rpm-build-gir
BuildRequires: biblesync-devel >= 2.0.1
BuildRequires: cmake desktop-file-utils intltool libGConf libdbus-glib-devel libdbus-devel 
BuildRequires: libappstream-glib libdbus-glib-devel libminizip-devel libwebkit2gtk-devel  libdatrie-devel libjpeg-devel 
BuildRequires: libsword-devel libwebkitgtk4-devel libxml2-devel yelp-tools 
BuildRequires: gcc gcc-c++ 
BuildRequires: libsoup-gir-devel libgtksourceview4-gir-devel


%description
Xiphos (formerly known as GnomeSword) is a Bible study application for GNOME,
a graphical desktop environment which is available for Linux and UNIX. Xiphos
is based on The SWORD Project by the CrossWire Bible Society, a framework for
providing tools useful for studying the Bible and additional information like
commentaries, dictionaries, and other texts using your computer.

%prep
%setup
#patch -p2
#patch1 -p2
#patch2 -p1
rm -rf src/biblesync

echo %{version} >cmake/source_version.txt

%patch3 -p1


%build
export CFLAGS="%{optflags} -Wno-dev -Wno-return-type"
export CXXFLAGS="%{optflags} -Wno-dev -Wno-return-type `pkg-config --cflags dbus-glib`"
export PYTHON="%{_bindir}/python3"
%cmake -DEPUB:BOOL=OFF -DCMAKE_INSTALL_DOCDIR:PATH=%{_docdir}/%{name} -DPOSTINST:BOOL=OFF
%cmake_build


%install
%cmake_install

desktop-file-install --delete-original         \
    --add-category=X-Bible                     \
    --add-category=X-Religion                  \
    --dir=%{buildroot}%{_datadir}/applications \
    --copy-name-to-generic-name                \
    %{buildroot}%{_datadir}/applications/xiphos.desktop


# package docs with macro
#rm -frv %{buildroot}%{_docdir}/%{name}

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS ChangeLog README.md RELEASE-NOTES TODO COPYING
%_bindir/*
%_datadir/metainfo/%name.appdata.xml
%_desktopdir/%name.desktop
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/%name
%_datadir/help
%_datadir/doc/%name
%_datadir/locale/*/LC_MESSAGES/%name.mo
%_man1dir/%{name}*

%changelog
