%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%def_disable static

%ifarch armh
%add_optflags -DUATOMIC_NO_LINK_ERROR
%endif

Name: xfsprogs
Version: 6.17.0
Release: alt1

Summary: Utilities for managing the XFS filesystem
License: LGPL-2.1 and GPL-2.0
Group: System/Kernel and hardware

Url: https://xfs.wiki.kernel.org/
VCS: https://git.kernel.org/pub/scm/fs/xfs/xfsprogs-dev.git
Source: %name-%version-%release.tar
Patch0: %name-%version-alt.patch

Requires: libxfs = %EVR
# makefiles are buggy
BuildConflicts: libxfs-devel

BuildRequires: gcc-c++
BuildRequires: libuuid-devel libblkid-devel 
BuildRequires: libsystemd-devel rpm-build-python3
BuildRequires: libinih-devel libuserspace-rcu-devel
BuildRequires: libedit-devel

%description
XFS is a high performance journaling filesystem which originated
on the SGI IRIX platform.  It is completely multi-threaded, can
support large files and large filesystems, extended attributes,
variable block sizes, is extent based, and makes extensive use of
Btrees (directories, extents, free space) to aid both performance
and scalability.

Refer to the documentation at http://oss.sgi.com/projects/xfs/
for complete details.  This implementation is on-disk compatible
with the IRIX version of XFS.

This package contains a set of commands to use the XFS filesystem,
including mkfs.xfs.

%package -n libxfs
Summary: XFS filesystem-specific libraries
Group: System/Libraries

%description -n libxfs
This package contains the library needed to run programs dynamically
linked with libxfs.

%package -n libxfs-devel
Summary: XFS filesystem-specific devel libraries and headers
Group: Development/C
Requires: libxfs = %version-%release

%description -n libxfs-devel
libxfs-devel contains the libraries and header files needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel if you want to develop XFS
filesystem-specific programs, If you install libxfs-devel, you'll
also want to install xfsprogs.

%if_enabled static
%package -n libxfs-devel-static
Summary: XFS filesystem-specific static libraries
Group: Development/C
Requires: libxfs-devel = %version-%release

%description -n libxfs-devel-static
libxfs-devel-static contains the static libraries needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel-static if you want to develop XFS
filesystem-specific programs.

If you install libxfs-devel-static, you'll also want to install xfsprogs.
%endif

%prep
%setup
%patch0 -p1

%build
export tagname=CC
make configure
%configure \
	--libexecdir=%_libdir \
	--enable-lto=no \
	--enable-blkid=yes \
	--enable-editline=yes
%make_build DEBUG=-DNDEBUG

%install
%make DIST_ROOT=%buildroot PKG_INC_DIR=%_includedir/xfs PKG_ROOT_SBIN_DIR=%_sbindir PKG_ROOT_LIB_DIR=%_libdir install install-dev 
mkdir -p %buildroot%_libdir

# don't use crontab 
rm -f %buildroot/%_lib/xfsprogs/xfs_scrub_all.cron
# Workaround bug in makefiles
rm -rf %buildroot%_datadir/doc/%name

%find_lang %name

%pre
%_sbindir/groupadd -r -f _xfsscrub ||:
%_sbindir/useradd -M -r -d / -s /bin/false -c "Special User for the XFS Scrub service" -g _xfsscrub _xfsscrub >/dev/null 2>&1 ||:


%files -f %name.lang
%_sbindir/*
%_unitdir/*.service
%_unitdir/*.timer
%_unitdir/system-xfs_scrub.slice
%dir %_datadir/xfsprogs
%dir %_datadir/xfsprogs/mkfs
%dir %_libdir/xfsprogs
%_libdir/xfsprogs/xfs_scrub_fail
%_datadir/xfsprogs/xfs_scrub_all.cron
%_datadir/xfsprogs/mkfs/*.conf
%_mandir/man[85]/*
%doc doc/CHANGES.gz doc/CREDITS README

%files -n libxfs
%_libdir/*.so.*

%files -n libxfs-devel
%_libdir/*.so
%dir %_includedir/xfs
%_includedir/xfs/handle.h
%_includedir/xfs/jdm.h
%_includedir/xfs/linux.h
%_includedir/xfs/xfs.h
%_includedir/xfs/xfs_fs.h
%_includedir/xfs/xfs_arch.h
%_includedir/xfs/xfs_da_format.h
%_includedir/xfs/xfs_format.h
%_includedir/xfs/xfs_log_format.h
%_includedir/xfs/xfs_fs_compat.h
%_includedir/xfs/xfs_types.h
%_includedir/xfs/xqm.h
%_man2dir/*
%_man3dir/*

%if_enabled static
%files -n libxfs-devel-static
%_libdir/*.a
%endif

%changelog
