Name: xfce4-screenshooter
Version: 1.11.3
Release: alt1

Summary: Screenshot Xfce4 panel plugin
Summary (ru_RU.UTF-8): Дополнение для панели Xfce позволяющее делать снимки экрана
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/apps/screenshooter/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/apps/xfce4-screenshooter.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

%if_xfce4_wayland_support
%def_enable wayland
%else
%def_disable wayland
%endif

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4panel-gtk3-devel libxfce4ui-gtk3-devel libxfce4util-devel libexo-gtk3-devel libxfconf-devel
BuildRequires: libX11-devel libXi-devel libXext-devel libXfixes-devel libXtst-devel
%{?_enable_wayland:BuildRequires: wayland-devel libwayland-client-devel wlr-protocols wayland-protocols libgtk-layer-shell-devel}
BuildRequires: libpango-devel >= 1.44.0

BuildRequires: help2man

Provides:  xfce4-screenshooter-plugin = %version-%release
Obsoletes: xfce4-screenshooter-plugin < %version-%release

%define _unpackaged_files_terminate_build 1

%description
This application allows you to capture the entire screen, the active
window or a selected region.
You can set the delay that elapses before the screenshot is taken
and the action that will be done with the screenshot: save it to a PNG
file, copy it to the clipboard, or open it using another application.

A plugin for the Xfce panel is also available.

%description -l ru_RU.UTF-8
Стандартное приложение Xfce позволяющее делать снимки экрана. Программа
основана на gnome-screenshot и имеет схожие функции. Имеется возможность
управления как мышкой так и с помощью "горячих" клавишь.

Дополнение для панели Xfce так же включено.

%prep
%setup
%patch -p1

%build
%meson \
	-Dx11=enabled \
	%{subst_enable_meson_feature wayland wayland}

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README.md AUTHORS NEWS
%_libdir/xfce4/panel/plugins/*.so
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/applications/*.desktop
%_datadir/metainfo/*.xml
%_bindir/xfce4-screenshoot*
%_mandir/man1/xfce4-screenshooter*

%changelog
