%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 1.3

%def_enable check

Name: xdg-desktop-portal-hyprland
Version: %ver_major.11
Release: alt1

Summary: xdg-desktop-portal backend for Hyprland
Group: Graphical desktop/Other
License: BSD-3-Clause
Url: https://github.com/hyprwm/xdg-desktop-portal-hyprland

Vcs: https://github.com/hyprwm/xdg-desktop-portal-hyprland.git

%if_disabled snapshot
Source: %url/archive/v%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

ExcludeArch: %ix86 armh

Requires: xdg-desktop-portal
Requires: qt6-wayland

BuildRequires(pre): rpm-macros-cmake rpm-build-systemd
BuildRequires: cmake gcc-c++ ctest
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-protocols)
BuildRequires: pkgconfig(hyprland-protocols) >= 0.6.4
BuildRequires: hyprwayland-scanner >= 0.4.2
BuildRequires: pkgconfig(hyprlang)
BuildRequires: pkgconfig(hyprutils) >= 0.2.6
BuildRequires: pkgconfig(libpipewire-0.3) >= 1.2
BuildRequires: pkgconfig(gbm)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(sdbus-c++) >= 2.0.0
BuildRequires: pkgconfig(libsystemd)
BuildRequires: qt6-tools pkgconfig(Qt6Widgets)

%description
XDG Desktop Portal implementation for Hyprland.

%prep
%setup -n %name-%version

%build
%cmake -DCMAKE_BUILD_TYPE=Release
%nil
%cmake_build

%install
%cmake_install
%find_lang %name

%check
%ctest

%files -f %name.lang
%_bindir/hyprland-share-picker
%_libexecdir/%name
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.hyprland.service
%_datadir/xdg-desktop-portal/portals/hyprland.portal
%_userunitdir/%name.service
%doc README*


%changelog
