%def_with check

Name: xcp
Version: 0.24.2
Release: alt1
Summary: An extended cp
License: GPL-3.0
Group: File tools
Url: https://crates.io/crates/xcp
VCS: https://github.com/tarka/xcp

Source: %name-%version.tar
Source1: vendor.tar
Patch1: alt-fix-i586-armh-build.patch
Patch3500: alt-loongarch64-fiemap.patch

BuildRequires(pre): rpm-macros-rust
BuildRequires: rpm-build-rust
BuildRequires: cargo-vendor-checksum
BuildRequires: diffstat
BuildRequires: rust-cargo

%if_with check
BuildRequires: libacl-devel
%endif

%description
xcp is a (partial) clone of the Unix cp command. It is not intended
as a full replacement, but as a companion utility with some more
user-friendly feedback and some optimisations that make sense under
certain tasks.

%prep
%setup -a 1
%rust_prep
%ifarch i586 armh
%patch1 -p1
%endif

%patch3500 -p1
diffstat -p1 -l < %PATCH3500 | sed -re 's@vendor/@@' | xargs cargo-vendor-checksum -f

%build
%rust_build

%install
%rust_install

%check
./tests/scripts/test-linux.sh

%files
%_bindir/%name

%changelog
