Name:          xar
Version:       1.6.1.13
Release:       alt0.1

Summary:       The XAR project aims to provide an easily extensible archive format
License:       BSD-3-Clause
Group:         Archiving/Compression
Url:           https://github.com/mackyle/xar
Vcs:           https://git.altlinux.org/gears/x/xar.git

Source:        %name-%version.tar
Requires:      lib%name = %version-%release

BuildRequires: bzlib-devel
BuildRequires: libacl-devel
BuildRequires: libe2fs-devel
BuildRequires: libssl-devel
BuildRequires: libxml2-devel
BuildRequires: liblzma-devel
BuildRequires: zlib-devel
BuildRequires: xsltproc
BuildRequires: rsync

%description
The XAR project aims to provide an easily extensible archive format.
Important design decisions include an easily extensible XML table of
contents for random access to archived files, storing the toc at the
beginning of the archive to allow for efficient handling of streamed
archives, the ability to handle files of arbitrarily large sizes,
the ability to choose independent encodings for individual files in
the archive, the ability to store checksums for individual files in
both compressed and uncompressed form, and the ability to query the
table of content's rich meta-data.

Please note that the code quality of this project is quite poor.
Do not expect that error conditions would be handled properly.


%package       -n lib%name
Summary:       The eXtensible ARchiver runtime library
Group:         System/Libraries

%description   -n lib%name
The XAR project aims to provide an easily extensible archive format.
This package contains the eXtensible ARchiver runtime library.

Please note that the code quality of this project is quite poor.
Do not expect that error conditions would be handled properly.


%package       -n lib%name-devel
Summary:       Development files for the eXtensible ARchiver library
Group:         Development/C

Requires:      lib%name = %version-%release
Requires:      bzlib-devel
Requires:      libacl-devel
Requires:      libe2fs-devel
Requires:      libssl-devel
Requires:      libxml2-devel
Requires:      liblzma-devel
Requires:      zlib-devel
Requires:      xsltproc
Requires:      rsync

%description   -n lib%name-devel
The XAR project aims to provide an easily extensible archive format.

This package contains headers and other development files required to
build XAR-based software.

%prep
%setup

%build
cd xar
autoconf
%configure --disable-static --enable-autogen
%make_build

%install
cd xar
%makeinstall_std

%files
%_bindir/*
%_man1dir/*
%doc xar/LICENSE xar/NEWS xar/INSTALL xar/ChangeLog

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so

%changelog
