# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict,unresolved=normal

%def_with python
%def_with python3
%ifarch %e2k
# needs thorough update, esp. rpm-macros-ruby
%def_without ruby
%else
%def_with ruby
%endif
%def_without doc

Name: xapian-bindings
Version: 1.4.30
Release: alt1
Summary: Xapian search engine bindings
License: GPL-2.0-or-later
Group: Development/Databases
Url: http://www.xapian.org/
Vcs: git://git.xapian.org/xapian

Source: http://www.oligarchy.co.uk/xapian/%version/%name-%version.tar
Source100: xapian-bindings.watch
Patch1: xapian-bindings-1.4.27-alt-no-docs.patch

BuildRequires: gcc-c++
BuildRequires: libruby-devel
BuildRequires: libxapian-devel = %version
%if_with ruby
BuildRequires(pre): rpm-macros-ruby
BuildRequires: gem(test-unit)
BuildRequires: rpm-build-ruby
%endif
%if_with python
%setup_python_module %name
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
%endif
%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx-devel
%endif

%define libxapianEVR %(rpm -q libxapian-devel --requires | grep ^libxapian 2>/dev/null || echo unknown)

%description
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

This package contains programming language bindings.

%package -n python-module-xapian
Summary: Python bindings for Xapian search engine
Group: Development/Python
Requires: %libxapianEVR

%description -n python-module-xapian
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

This package provides the files needed for developing Python scripts
which use Xapian.

%package -n python3-module-xapian
Summary: Python 3 bindings for Xapian search engine
Group: Development/Python3
Requires: %libxapianEVR

%description -n python3-module-xapian
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

This package provides the files needed for developing Python 3 scripts
which use Xapian.

%package -n ruby-xapian
Summary: Ruby bindings for Xapian search engine
Group: Development/Ruby
Requires: %libxapianEVR

%description -n ruby-xapian
Xapian is a highly adaptable toolkit which allows developers to easily
add advanced indexing and search facilities to their own applications.
It has built-in support for several families of weighting models
and also supports a rich set of boolean query operators.

This package provides the files needed for developing Ruby scripts
which use Xapian.

%prep
%setup
%if_without doc
%patch1 -p2
%endif
# Link to the libruby for a proper dependency.
sed -i '/_xapian_la_LDFLAGS/s/$/ -lruby/' ruby/Makefile.am

# Workaround to https://bugzilla.altlinux.org/44173
%define ruby_vendorarchdir %(ruby -rrubygems -rrbconfig -e 'puts RbConfig::CONFIG["vendorarchdir"]')

%build
%ifarch %e2k
# http://stackoverflow.com/questions/14892101/
%add_optflags -ftls-model=global-dynamic
%endif
%autoreconf
export RUBY_LIB=%ruby_vendorlibdir
export RUBY_LIB_ARCH=%ruby_vendorarchdir
export RDOC=$(PATH=/usr/lib/ruby/bin:$PATH type -p rdoc)
%configure %{subst_with python} %{subst_with python3} %{subst_with ruby}
%make_build

%install
%makeinstall_std
rm -rf %buildroot%_defaultdocdir/%name/

%check
%if_with ruby
  ruby -Iruby -Iruby/.libs -rxapian -e '(p Xapian.version_string) == "%version"'
  make -C ruby check VERBOSE=1
%endif
%if_with python
  make -C python check VERBOSE=1
%endif
%if_with python3
  make -C python3 check VERBOSE=1
%endif

%if_with python
%files -n python-module-xapian
%doc README python/docs/*
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-xapian
%doc README python/docs/*
%python3_sitelibdir/*
%endif

%if_with ruby
%files -n ruby-xapian
%doc README ruby/docs/*
%ruby_vendorarchdir/_xapian.so
%ruby_vendorlibdir/xapian.rb
%endif

%changelog
