%define soversion 215
Name: x265
Version: 4.1
Release: alt2
Summary: H.265/HEVC encoder
License: GPLv2
Group: Video
Url: https://www.x265.org/
VCS: https://bitbucket.org/multicoreware/x265_git.git
Source: %name-%version.tar
Patch0: x265-%version-%release.patch
BuildRequires: cmake gcc-c++ nasm libnuma-devel
BuildRequires: /proc

%description
H.265/HEVC encoder

%package -n libx265-%soversion
Summary: H.265/HEVC encoder library
Group: System/Libraries
Obsoletes: libx265 = 2.5-alt1

%package -n libx265-devel
Summary: Development files of H.265/HEVC encoder library
Group: Development/C
Requires: libx265-%soversion = %EVR

%description -n libx265-%soversion
H.265/HEVC encoder library

%description -n libx265-devel
Development files of H.265/HEVC encoder library

%prep
%setup
%patch0 -p1

sed -i	-e '/X265_VERSION / s,unknown,%version,' \
	-e '/X265_LATEST_TAG / s,0\.0,%version,' \
	-e '/^#Find version control software.*/i return()' \
	source/cmake/Version.cmake

%build
%add_optflags %optflags_shared
%define _cmake__builddir $builddir
build() {
%cmake \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DLIB_INSTALL_DIR=%_lib \
        -DHIGH_BIT_DEPTH=ON \
	-DCMAKE_SKIP_RPATH:BOOL=YES \
	-DCMAKE_POSITION_INDEPENDENT_CODE:BOOL=ON \
	-DENABLE_PIC:BOOL=ON \
	-DENABLE_TESTS:BOOL=ON \
	-DCMAKE_ASM_NASM_FLAGS=-w-macro-params-legacy \
	$* \
	-S source
%cmake_build
}

%ifarch x86_64 aarch64
builddir=10bit
    build \
    -DMAIN10=ON \
    -DENABLE_CLI=OFF \
    -DENABLE_ALTIVEC=OFF \
    -DEXPORT_C_API=OFF \
    -DENABLE_SHARED=OFF \
    -DHIGH_BIT_DEPTH=ON

builddir=12bit
    build \
    -DHIGH_BIT_DEPTH=ON \
    -DENABLE_SHARED=OFF \
    -DEXPORT_C_API=OFF \
    -DENABLE_CLI=OFF \
    -DENABLE_ALTIVEC=OFF \
    -DMAIN12=ON
%endif

%ifarch x86_64 aarch64
mkdir 8bit
ln -s ../12bit/libx265.a 8bit/libx265_main12.a
ln -s ../10bit/libx265.a 8bit/libx265_main10.a
%endif

# 8 bit base library + encoder
builddir=8bit 
    build \
    -DENABLE_SHARED=ON \
    -DHIGH_BIT_DEPTH=OFF \
%ifarch x86_64 aarch64
    -D EXTRA_LIB='x265_main10.a;x265_main12.a' \
    -D EXTRA_LINK_FLAGS='-L.' \
    -DLINKED_10BIT=ON \
    -DLINKED_12BIT=ON \
%endif
%ifarch %ix86
      -DENABLE_ASSEMBLY=OFF \
%endif
    #

%install
%define _cmake__builddir 8bit
%cmake_install

find %buildroot -name "*.a" -delete

%check
pushd 8bit
test/TestBench || :

%files
%_bindir/x265

%files -n libx265-%soversion
%_libdir/libx265.so.%soversion

%files -n libx265-devel
%_libdir/libx265.so
%_includedir/x265.h
%_includedir/x265_config.h
%_pkgconfigdir/*

%changelog
