Name: wireless-tools
Version: 29
Release: alt11
%define fullname wireless_tools.%version

Summary: Wireless ethernet configuration tools
Summary(ru_RU.UTF-8): Утилиты для настройки беспроводных сетей
Group: System/Kernel and hardware
# Most of the code contains the following notice:
# This file is released under the GPL license.
# The COPYING file contains the text of GPLv2.
# iwevent.c contains code copied from a GPLv2+ project.
License: GPL-2.0-or-later
Url: http://www.hpl.hp.com/personal/Jean_Tourrilhes/Linux/Tools.html
# http://www.hpl.hp.com/personal/Jean_Tourrilhes/Linux/%fullname.tar.gz
Source0: %fullname.tar
Source1: iftab2rules
Patch1: wireless-tools-29-alt-makefile.patch
Patch2: wireless-tools-29-alt-ifrename-nowarn.patch

Requires: libwireless = %version-%release

%description
This package contain the Wireless tools, used to manipulate
the Wireless Extensions.  The Wireless Extension is an interface
allowing you to set Wireless LAN specific parameters and get the
specific stats for wireless networking equipment.

This is specifically useful since it allows manipulation of encryption
parameters possible with the GPL WaveLAN cards.

%description -l ru_RU.UTF-8
Этот пакет содержит набор программ, которые предназначены для настройки
и управления беспроводными сетевыми платами под Linux.

%package -n ifrename
Group: System/Kernel and hardware
Summary: %name tool renames network interfaces
Summary(ru_RU.UTF-8): утилита %name переименовывает сетевые интерфейсы
Requires: libwireless = %version-%release

%description -n ifrename
This package contains ifrename - a tool to rename network interfaces
considering different criterias consisting of: MAC address, link type,
module name, bus information, memory base address, irq line and wireless
protocol.  ifrename may be used by etcnet and udev packages, although
can be used standalone.

%description -n ifrename -l ru_RU.UTF-8
Этот пакет содержит ifrename.  Утилита предназначена для переименования
интерфейсов на основании критериев, которые включают MAC-адрес, канальный
тип интерфейса, имя модуля, расположение на системной шине, базовый адрес
разделяемой памяти, номер прерывания и беспроводный протокол.  Утилита
ifrename, в частности, может использоваться пакетами etcnet и udev, хотя
может быть использована и самостоятельно.

%package -n libwireless
Group: System/Libraries
Summary: Runtime library for %name

%description -n libwireless
This package contain runtime library for %name.

%package -n libwireless-devel
Group: Development/C
Summary: Development files for %name
Requires: libwireless = %version-%release
Obsoletes: %name-devel
Provides: %name-devel = %version-%release

%description -n libwireless-devel
This package contains development files for %name.

%prep
%setup -n %fullname
%patch1 -p1
%patch2 -p1

%build
make clean
make CFLAGS='%optflags -I.' IWLIBS='-L. -liw' BUILD_SHARED=1

%install
make install INSTALL_DIR=%buildroot/sbin \
	INSTALL_LIB=%buildroot%_libdir \
	INSTALL_INC=%buildroot%_includedir \
	INSTALL_MAN=%buildroot%_mandir

# Relocate shared library from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

mkdir -p %buildroot%_sysconfdir
touch %buildroot%_sysconfdir/iftab

install -pDm755 %_sourcedir/iftab2rules \
	%buildroot/lib/ifrename/iftab2rules

%define convert_flag /var/run/ifrename-iftab2rules
%pre -n ifrename
rm -f %convert_flag
old_rules=/etc/udev/rules.d/19-udev-ifrename.rules
if [ $1 -ge 2 ] &&
   [ -s "$old_rules" ] &&
   grep -qs '^[[:space:]]*[^[:space:]#]' /etc/iftab; then
	if [ -x /lib/udev/write_net_rules ]; then
		touch %convert_flag
	else
		new_rules=/etc/udev/rules.d/70-persistent-net.rules
		cat >&2 <<EOF
WARNING: Old udev rules file $old_rules cannot be
converted to new udev rules file $new_rules,
udev persistent network rules is most likely to break after this update.
EOF
	fi
fi

%post -n ifrename
[ -f %convert_flag ] || exit 0
rm -f %convert_flag /etc/udev/rules.d/19-udev-ifrename.rules
exec /lib/ifrename/iftab2rules

%files
%doc INSTALL README DISTRIBUTIONS.txt
/sbin/*
%exclude /sbin/ifrename
%_mandir/man?/*
%exclude %_man8dir/ifrename*
%exclude %_man5dir/iftab*

%files -n ifrename
%config(noreplace,missingok) %verify(not md5 mtime size) %ghost %_sysconfdir/iftab
/sbin/ifrename
/lib/ifrename
%_man8dir/ifrename*
%_man5dir/iftab*

%files -n libwireless
/%_lib/*.so.*

%files -n libwireless-devel
%_libdir/*.so
%_includedir/*

%changelog
