%define commit e73c4d8f71801fe842c0276b603d9c8024d6d957
Name: winetricks
Version: 20250207
Release: alt3

Summary: Work around common problems in Wine

License: LGPLv2+
Group: File tools
Url: https://github.com/Winetricks/winetricks

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source-url: %url/archive/%version/%name-%version.tar.gz
# Source-url: https://github.com/Winetricks/winetricks/commit/%commit
Source: %name-%version.tar

Patch2: 0001-winetricks-try-use-xvt-as-terminal.patch
Patch3: 0001-winetricks-W_NO_WIN64_WARNINGS-1.patch

Patch10: 0001-Remove-unuseful-binary-arch-detection.patch
#Patch11: 0002-add-w_expand_env32-and-w_expand_env64-and-using-them.patch
Patch12: 0001-Rename-w_try_regsvr-to-w_try_regsvr32.patch

Patch21: 0006-install-correct-version-of-msvcp140.patch
Patch22: 0001-ie8-removed-dll-that-cannot-be-registered.patch

BuildArch: noarch

ExclusiveArch: %ix86 x86_64 %arm aarch64

#BuildRequires: wine-common
BuildRequires: desktop-file-utils

# add wine dependency to remove winetricks with wine (ALT bug 36241)
Requires: /usr/bin/wine

Requires: cabextract gzip unzip wget which

# skip optional deps
%filter_from_requires /^kde5-kdialog/d
%filter_from_requires /^kdialog/d
%filter_from_requires /^zenity/d


#Requires: hicolor-icon-theme
Conflicts: wine-vanilla < 3.18
Conflicts: wine < 3.18
Conflicts: wine-etersoft < 4.0

%description
Winetricks is an easy way to work around common problems in Wine.

It has a menu of supported games/apps for which it can do all the
workarounds automatically. It also lets you install missing DLLs
or tweak various Wine settings individually.
 
%prep
%setup
%patch2 -p1
%patch3 -p1
%patch10 -p1
%patch12 -p1
%patch21 -p1
%patch22 -p1

# fix req. Disable autoreq at all?
%__subst 's|fusermount|a= fusermount|' src/winetricks
%__subst 's|wineuserpath=\$(winepath|wineuserpath=$(a= winepath|' src/winetricks

sed -i -e "s:steam::" -e "s:flash::" tests/*

%build
subst 's|WINETRICKS_VERSION=.*|WINETRICKS_VERSION=%version-%release|' src/winetricks
# disable version checking
subst 's|winetricks_latest_version_check$||' src/winetricks

%install
%makeinstall_std
# hack for empty output to console
subst 's|Terminal=false|Terminal=true|' %buildroot%_desktopdir/%name.desktop

%check
desktop-file-validate %buildroot%_desktopdir/%name.desktop

%files
%doc COPYING debian/copyright
%doc README.md
%_bindir/%name
%_man1dir/%name.1*
%_iconsdir/hicolor/scalable/apps/%name.svg
%_desktopdir/%name.desktop
%_datadir/metainfo/io.github.winetricks.Winetricks.metainfo.xml
%_datadir/bash-completion/completions/winetricks

%changelog
