%define ver_major 14.0
%define api_ver_major 14
%define api_ver %api_ver_major
%define clientsdir %_libdir/%name/clients
%define soname 1
%define exec_soname 0

# Weston backend: DRM/KMS
%def_enable backend_drm

# DRM/KMS backend support for VA-API screencasting
%def_enable backend_drm_screencast_vaapi

# Weston backend: headless (testing)
%def_enable backend_headless

# Weston backend: RDP remote screensharing
%def_enable backend_rdp

# Compositor: RDP screen-sharing support
%def_enable screenshare

# Weston backend: Wayland (nested)
%def_enable backend_wayland

# Weston backend: X11 (nested)
%def_enable backend_x11

# VNC remote screensharing
%def_enable backend_vnc

# Default backend when no parent display server detected
# 'auto', 'drm', 'wayland', 'x11', 'fbdev', 'headless'
%define backend_default drm

# Weston renderer: EGL / OpenGL ES 2.x
%def_enable renderer_gl

# Weston launcher for systems without logind (removed since 11.0.0)
%def_disable deprecated_weston_launch

# Compositor: support systemd-logind D-Bus protocol (deprecated since 12.0.0)
%def_disable launcher_logind

# Compositor: support libseat (enabled by default)
%def_enable launcher_libseat

# Xwayland: support for X11 clients inside Weston
%def_enable xwayland

# systemd service plugin: state notify, watchdog, socket activation
%def_enable systemd

# Virtual remote output with GStreamer on DRM backend
%def_enable remoting

# Virtual remote output with Pipewire on DRM backend
%def_enable pipewire

# Weston shell UI: traditional desktop
%def_enable shell_desktop

# Weston shell UI: fullscreen/kiosk
%def_enable shell_fullscreen

# Weston shell UI: IVI (automotive)
%def_enable shell_ivi

# Weston shell UI: kiosk (desktop apps)
%def_enable shell_kiosk

# Weston desktop shell: default helper client selection
%define desktop_shell_client_default weston-desktop-shell

# Compositor color management: lcms
%def_enable color_management_lcms

# JPEG loading support
%def_enable image_jpeg

# WebP loading support
%def_enable image_webp

# List of accessory clients to build and install
# choices: [ 'calibrator', 'debug', 'info', 'terminal', 'touch-calibrator' ],
%define tools 'calibrator', 'debug', 'info', 'terminal', 'touch-calibrator'

# Sample clients: toytoolkit demo programs
%def_enable demo_clients

# Sample clients: simple test programs
%define simple_clients all
# choices: [ 'all', 'damage', 'im', 'egl', 'shm', 'touch', 'dmabuf-v4l', 'dmabuf-egl' ],

# Sample clients: optimize window resize performance
%def_enable resize_pool

# Tools: screen recording decoder tool
%def_enable wcap_decode

# Tests: output JUnit XML results
%def_enable test_junit_xml

# Tests: allow running with GL-renderer
%def_enable test_gl_renderer

# disabled by default
%def_disable doc

# running logind or seatd required
%def_disable check

Name: weston
Version: %ver_major.2
Release: alt1

Summary: Reference compositor for Wayland
Group: Graphical desktop/Other
License: MIT
Url: http://wayland.freedesktop.org/

Vcs: https://gitlab.freedesktop.org/wayland/weston.git
#Source: https://gitlab.freedesktop.org/wayland/weston/-/archive/%version/%name-%version.tar.gz
Source: %name-%version.tar
#Source1: %name.ini
Patch: %name-%version-%release.patch
#Patch2: weston-9.0.0-alt-launch-group.patch

Requires: lib%name = %EVR
Requires: xkeyboard-config
Requires: xorg-dri-swrast

%define pw_api_ver 0.3
%define pw_ver 0.3
%define gst_api_ver 1.0
%define mesa_ver 21.1.1

BuildRequires(pre): meson
BuildRequires(pre): rpm-build-xdg
%{?_enable_systemd:BuildRequires(pre): rpm-build-systemd}
%{?_enable_launcher_libseat:BuildRequires: pkgconfig(libseat)}
BuildRequires: libGLES-devel libglvnd-devel
BuildRequires: libdrm-devel
BuildRequires: libgbm-devel >= %mesa_ver
BuildRequires: libdisplay-info-devel
BuildRequires: libva-devel
BuildRequires: libwayland-client-devel
BuildRequires: libwayland-cursor-devel
BuildRequires: libwayland-egl-devel
BuildRequires: libwayland-server-devel
BuildRequires: wayland-protocols
BuildRequires: libpixman-devel
BuildRequires: libcairo-devel
BuildRequires: libpango-devel
BuildRequires: libevdev-devel
BuildRequires: libinput-devel
BuildRequires: libxkbcommon-devel
BuildRequires: libdbus-devel
BuildRequires: libpam0-devel
%{?_enable_image_jpeg:BuildRequires: libjpeg-devel}
%{?_enable_image_webp:BuildRequires: libwebp-devel}
%{?_enable_color_management_lcms:BuildRequires: liblcms2-devel}
%{?_enable_xwayland:
BuildRequires: xorg-xwayland-devel
BuildRequires: pkgconfig(xcb) pkgconfig(xcb-composite)
BuildRequires: pkgconfig(xcb-shape) pkgconfig(xcb-xfixes) pkgconfig(xcb-cursor)
BuildRequires: pkgconfig(xcursor) pkgconfig(cairo-xcb)}
%{?_enable_backend_rdp:BuildRequires: libfreerdp3-devel}
%{?_enable_backend_x11:BuildRequires: pkgconfig(xcb) pkgconfig(xcb-xkb)}
%{?_enable_pipewire:BuildRequires: pkgconfig(libpipewire-%pw_api_ver) >= %pw_ver}
%{?_enable_remoting:
BuildRequires: pkgconfig(gstreamer-%gst_api_ver) pkgconfig(gstreamer-allocators-%gst_api_ver)
BuildRequires: pkgconfig(gstreamer-app-%gst_api_ver) pkgconfig(gstreamer-video-%gst_api_ver)}
%{?_enable_test_junit_xml:BuildRequires: libxml2-devel}
%{?_enable_check:BuildRequires: xkeyboard-config /%_bindir/Xwayland}
%{?_enable_backend_vnc:BuildRequires: libaml-devel libneatvnc-devel >= 0.8}

%description
Weston is the reference wayland compositor that can run on KMS, under X11
or under another compositor.

%package -n lib%name
Summary: Weston compositor libraries
Group: System/Libraries

%description -n lib%name
This package contains Weston compositor libraries.

%package -n lib%name-devel
Summary: Development libraries for weston
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Header and Library files for doing development with the weston.

%package -n lib%name-protocols
Summary: Development libraries for weston
Group: Development/C
BuildArch: noarch
Requires: lib%name-devel = %EVR

%description -n lib%name-protocols
Header and Library files for doing development with the weston.

%package devel
Summary: Development files for weston
Group: Development/C
Requires: %name = %EVR
Requires: lib%name-devel = %EVR

%description devel
Header files for doing development with the weston.

%prep
%setup
%patch -p1
%{?_enable_deprecated_weston_launch:%patch2 -p1 -b .launch_group}

%build
%meson \
    %{?_enable_deprecated_weston_launch:-Ddeprecated-weston-launch=true \
    -Dweston-launch-group=xgrp} \
    --libexecdir=%clientsdir \
    %{subst_enable_meson_bool backend_x11 backend-x11} \
    %{subst_enable_meson_bool backend_rdp backend-rdp} \
    %{subst_enable_meson_bool backend_vnc backend-vnc} \
    %{subst_enable_meson_bool xwayland xwayland} \
    %{subst_enable_meson_bool remoting remoting} \
    %{subst_enable_meson_bool shell_ivi shell-ivi} \
    %{subst_enable_meson_bool pipewire pipewire} \
    %{subst_enable_meson_bool test_junit_xml test-junit-xml}
%nil
%meson_build -v

%install
%meson_install
mkdir -p -- %buildroot/%_xdgconfigdir/%name
sed \
    -e 's,@clientsdir@,%clientsdir,g' \
    .gear/%name.ini > %buildroot/%_xdgconfigdir/%name/%name.ini

ln -sf %name/libexec_%{name}.so.%exec_soname \
%buildroot%_libdir/libexec_%{name}.so.%exec_soname

%check
%__meson_test

%files
%dir %_xdgconfigdir/%name
%{?_enable_backend_vnc:%_sysconfdir/pam.d/%name-remote-access}
%config(noreplace) %_xdgconfigdir/%name/%name.ini
%_bindir/*
%{?_enable_deprecated_weston_launch:%attr (4710,root,xgrp) %_bindir/weston-launch}
%dir %_libdir/%name
%{?_enable_color_management_colord:%_libdir/%name/cms-colord.so}
%{?_enable_deprecated_color_management_static:%_libdir/%name/cms-static.so}
%{?_enable_shell_desktop:%_libdir/%name/desktop-shell.so}
%{?_enable_shell_fullscreen:%_libdir/%name/fullscreen-shell.so}
%{?_enable_shell_ivi:
%_libdir/%name/hmi-controller.so
%_libdir/%name/ivi-shell.so}
%{?_enable_shell_kiosk:%_libdir/%name/kiosk-shell.so}
%{?_enable_screenshare:%_libdir/%name/screen-share.so}
%{?_enable_systemd:%_libdir/%name/systemd-notify.so}
# clients
%dir %_libdir/%name/clients
%{?_enable_shell_desktop:%_libdir/%name/clients/%name-desktop-shell}
%{?_enable_shell_ivi:%_libdir/%name/clients/%name-ivi-shell-user-interface}
%_libdir/%name/clients/%name-keyboard
%_libdir/%name/clients/%name-simple-im

%_datadir/%name/
%_datadir/wayland-sessions/%name.desktop
%_man1dir/%{name}*
%_man5dir/%{name}*
%_man7dir/%{name}*

%files devel
%_includedir/%name
%_pkgconfigdir/%name.pc

%files -n lib%name
%_libdir/lib%{name}*.so.*
%dir %_libdir/lib%name-%api_ver
%{?_enable_renderer_gl:%_libdir/lib%name-%api_ver/gl-renderer.so}
%{?_enable_remoting:%_libdir/lib%name-%api_ver/remoting-plugin.so}
%{?_enable_xwayland:%_libdir/lib%name-%api_ver/xwayland.so}
%{?_enable_pipewire:%_libdir/lib%name-%api_ver/pipewire-plugin.so}
%_libdir/%name/libexec_weston.so.*
#  symlink
%_libdir/libexec_%{name}.so.%exec_soname
# backends
%_libdir/lib%name-%api_ver/drm-backend.so
%{?_enable_deprecated_backend_fbdev:%_libdir/lib%name-%api_ver/fbdev-backend.so}
%{?_enable_backend_headless:%_libdir/lib%name-%api_ver/headless-backend.so}
%{?_enable_backend_rdp:%_libdir/lib%name-%api_ver/rdp-backend.so}
%{?_enable_backend_wayland:%_libdir/lib%name-%api_ver/wayland-backend.so}
%{?_enable_backend_x11:%_libdir/lib%name-%api_ver/x11-backend.so}
%{?_enable_color_management_lcms:%_libdir/lib%name-%api_ver/color-lcms.so}
%{?_enable_pipewire:%_libdir/lib%name-%api_ver/pipewire-backend.so}
%{?_enable_backend_vnc:%_libdir/lib%name-%api_ver/vnc-backend.so}

%files -n lib%name-devel
%_includedir/lib%name-%api_ver/
%_libdir/lib%{name}*.so
%_libdir/%name/libexec_weston.so
%_pkgconfigdir/lib%{name}*.pc

%files -n lib%name-protocols
%_datadir/lib%name-%api_ver/protocols/
%_datadir/pkgconfig/lib%name-%api_ver-protocols.pc

%changelog
