Name: waybar
Version: 0.12.0
Release: alt1
License: MIT
Summary: Highly customizable Wayland bar for Sway and Wlroots based compositors
URL: https://github.com/Alexays/Waybar.git
Group: Graphical desktop/Other

Source: %name-%version.tar

Patch0: waybar-config.patch

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

BuildRequires(pre): rpm-build-xdg

BuildRequires: cmake meson
BuildRequires: gcc-c++
BuildRequires: libstdc++-devel-static
BuildRequires: pkgconfig(fmt)
BuildRequires: pkgconfig(gtkmm-3.0)
BuildRequires: pkgconfig(jsoncpp)
BuildRequires: pkgconfig(libevdev)
BuildRequires: pkgconfig(libinput)
BuildRequires: pkgconfig(scdoc)
BuildRequires: pkgconfig(sigc++-2.0)
BuildRequires: pkgconfig(spdlog)
BuildRequires: pkgconfig(wayland-client)
BuildRequires: pkgconfig(wayland-cursor)
BuildRequires: pkgconfig(wayland-protocols)

# language module
BuildRequires: pkgconfig(xkbregistry)

# sni module
BuildRequires: pkgconfig(dbusmenu-gtk3-0.4)
BuildRequires: pkgconfig(gio-unix-2.0)

# pulseaudio module
BuildRequires: pkgconfig(libpulse)

# backlight
BuildRequires: pkgconfig(libudev)

# network module
BuildRequires: pkgconfig(libnl-3.0)
BuildRequires: pkgconfig(libnl-genl-3.0)

# upower module
BuildRequires: pkgconfig(upower-glib)

# mpd module
BuildRequires: pkgconfig(libmpdclient)

# wireplumber module
BuildRequires: pkgconfig(wireplumber-0.4)

# catch2 module
BuildRequires: pkgconfig(catch2)

BuildRequires: libgtk-layer-shell-devel

%define _libexecdir %_prefix/libexec
%define helperdir %_libexecdir/%name

%description
%summary.

%prep
%setup
#%%autopatch -p1

%build
%meson \
	-Drfkill=enabled \
	-Dsystemd=disabled
%meson_build

%install
%meson_install

%check
%meson_test

%files
%_bindir/%name
%dir %_xdgconfigdir/%name
%config(noreplace) %_xdgconfigdir/%name/config.jsonc
%config(noreplace) %_xdgconfigdir/%name/style.css
%_man5dir/*

%changelog
