Name: vkQuake
Version: 1.32.3.1
Release: alt2

Summary: Quake I engine
License: GPL-2.0
Group: Games/Arcade
Url: https://github.com/Novum/vkQuake

BuildRequires: glslang libSDL2-devel libvulkan-devel meson spirv-tools
BuildRequires: libflac-devel libvorbis-devel libopusfile-devel libmpg123-devel libstb-devel

Source: %name-%version.tar
# https://github.com/Novum/vkQuake/pull/809
Patch0: fix-build-with-glslang-16.patch

%description
Vulkan port of id software's Quake engine.

%description -l ru_RU.UTF-8
vkQuake - современный движок для игры Quake, базирующийся на Vulkan.
Основой движка послужили Quakespasm и его форк Quakespasm-spiked.
Обещается, что vkQuake быстрее, чем Quakespasm засчёт многопоточности.

В качестве Readme.maintainer см. аналогичный файл из пакета Quakespasm

%prep
%setup -q
%patch0 -p1
%ifarch %e2k
# error: unknown attribute "alloc_align"
sed -i 's/__INTEL_COMPILER/__EDG__/' Quake/mimalloc/mimalloc.h
sed -i 's/-Werror/-Wno-error/g' meson.build
%endif
# unbundle stb libraries
pushd Quake
ln -svf %_includedir/stb/stb_image.h \
	%_includedir/stb/stb_image_resize.h \
	%_includedir/stb/stb_image_write.h ./
popd

%build
%add_optflags -Wno-error=unused-function
%meson -Dmp3_lib=mpg123
%meson_build -v

%install
install -pDm755 %__builddir/vkquake %buildroot%_bindir/vkquake

%files
%doc LICENSE.txt readme.md
%_bindir/vkquake

%changelog
