%add_verify_elf_skiplist %_libdir/libvdehist.so*
%define _group vmuserss
%define major 2.3

Name: vde2
Version: %major.3
Release: alt1

Summary: Virtual Distributed Ethernet
License: GPL
Group: Networking/Other
Url: http://vde.sourceforge.net/
Packager: Igor Vlasenko <viy@altlinux.ru>

Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar
Source1: README.altlinux
Source2: vde.init
Source3: vde-external.conf
Source4: vde-internal.conf

Patch: vde2-2.2.2-alt-PATH_MAX-1.patch
Patch1: vde2-2.3.1-alt-link.patch

%def_disable static

BuildRequires: gcc-c++
BuildRequires: libssl-devel libpcap-devel

%description
VDE is a virtual network that can be spawned over a set of physical
computer over the Internet

VDE connects together:
  (1) real GNU-linux boxes (tuntap)
  (2) virtual machines: UML-User Mode Linux, qemu, bochs, MPS.

VDE can be used:
  (i) to create a general purpose tunnel (every protocol that runs
    on a Ethernet can be put into the tunnel)
  (ii) to connect a set of virtual machine to the Internet with no
    need of free access of tuntap
  (iii) to support mobility: a VDE can stay interconnected despite
    of the change of virtual cables, i.e. the change of IP addresses
    and interface in the real world

%package cryptcab
Summary: VDE ecryption module
License: GPL-2.0
Group: Networking/Other

%description cryptcab
This package contains CryptCab, which can be used
to send encrypted data over an UDP link.

%package slirp
Summary: VDE ecryption module
License: BSD-4-Clause AND MIT
Group: Networking/Other

%description slirp
slirpvde is a slirp interface for a VDE network.
Slirpvde  connects  all  the units (virtual or real machines) to the network
of the host where slirpvde runs as it were a NAT/Masquerading router.
The default route is the node 2 (10.0.2.2 in the default  network  configuration)
and DNS is re-mapped in node 3 (10.0.2.3).

Slirpvde  runs  using  standard user privileges (no need for root access):
all the connections are re-generated by slirpvde itself.

IPv4 only. IPv6 is still unsupported (will be supported when slirpvde
will be rewritten using the  LWIPv6  network stack).

%package -n libvdehist0
Summary: VDE history library
License: GPL-2.0
Group: Networking/Other

%description -n libvdehist0
This package contains VDE history library
A library to manage history and command completion for vde mgmt protocol

%package -n libvdemgmt0
Summary: VDE management library
License: GPL-2.0
Group: Networking/Other

%description -n libvdemgmt0
This package contains a library to interact with vde_switch
management console using pre-made unattended scripts.

%package -n libvdeplug3
Summary: VDE plug library
License: GPL-2.0
Group: Networking/Other

%description -n libvdeplug3
This package contains a library that makes programs able to connect
to a local VDE switch. The simplest one is vde_plug, contained in the vde2 package.

%package -n libvdesnmp0
Summary: VDE snmp library
License: GPL-2.0
Group: System/Libraries

%description -n libvdesnmp0
This package contains VDE snmp library
SNMP library for Virtual Distributed Ethernet

%package -n libvdehist-devel
Summary: VDE hist header files
License: GPL-2.0
Group: Development/C++
Requires: %name = %version
Requires: libvdehist0 = %version
Obsoletes: libvdehist0-devel < %version-%release
Provides: libvdehist0-devel = %version-%release

%description -n libvdehist-devel
This package contains VDE hist header files

%package -n libvdemgmt-devel
Summary: VDE management files
License: GPL-2.0
Group: Development/C++
Requires: %name = %version
Requires: libvdemgmt0 = %version
Obsoletes: libvdemgmt0-devel < %version-%release
Provides: libvdemgmt0-devel = %version-%release

%description -n libvdemgmt-devel
This package contains VDE management files

%package -n libvdeplug-devel
Summary: VDE plug header files
License: GPL-2.0
Group: Development/C++
Requires: %name = %version
Requires: libvdeplug3 = %version
Obsoletes: libvdeplug3-devel < %version-%release
Provides: libvdeplug3-devel = %version-%release

%description -n libvdeplug-devel
This package contains VDE plug header files

%package -n libvdesnmp-devel
Summary: VDE SNMP header files
License: GPL-2.0
Group: Development/C++
Requires: %name = %version
Requires: libvdesnmp0 = %version
Obsoletes: libvdesnmp0-devel < %version-%release
Provides: libvdesnmp0-devel = %version-%release

%description -n libvdesnmp-devel
This package contains VDE SNMP header files.

%prep
%setup
cp %SOURCE1 .
%patch0 -p1
#%%patch1 -p1

%build
autoreconf -fvi
# --enable-experimental even tho weird it has useful features and
#   vde2 on its own is no longer developed
%configure \
  --disable-silent-rules \
  --disable-static \
  --enable-experimental \
	
# Not thread safe makefiles
make -j1

%install
%makeinstall_std
find %buildroot -type f -name \*.la -delete

mkdir -p %buildroot%_initdir
install -m 0755 %SOURCE2 %buildroot%_initdir/%name
install -m 0644 %SOURCE3 %buildroot%_sysconfdir/%name/
install -m 0644 %SOURCE4 %buildroot%_sysconfdir/%name/
install -m 0770 -d %buildroot%_var/run/%name

%files
%doc Changelog README COPYING README.altlinux
%doc doc/README.VirtualBox doc/README.qemu doc/vde_autolink-HOWTO
%doc doc/README.UML doc/vdeqemu-HOWTO doc/README.vde_over_ns
%dir %_libdir/vde2
%dir %_sysconfdir/vde2
%_bindir/dpipe
%_bindir/unixcmd
%_bindir/vde_autolink
%_bindir/vde_over_ns
%_bindir/vde_pcapplug
%_bindir/vde_plug
%_bindir/vde_plug2tap
%_bindir/vde_switch
%_bindir/vde_router
%_bindir/vdecmd
%_bindir/vdeterm
%_bindir/wirefilter
%_libexecdir/vdetap
%_libdir/vde2/libvdetap.so
%dir %_libdir/vde2/plugins
%_libdir/vde2/plugins/dump.so
%_libdir/vde2/plugins/iplog.so
%_libdir/vde2/plugins/pdump.so
%config %_sysconfdir/vde2/vdecmd
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*
%_initdir/%name
%attr(750,root,%_group) %_var/run/%name
%_man1dir/*
%_man8dir/*
%exclude %_man1dir/vde_cryptcab.*
%exclude %_man1dir/slirpvde.*

%files -n libvdehist0
%doc Changelog README COPYING
%_libdir/libvdehist.so.0
%_libdir/libvdehist.so.0.0.1

%files -n libvdemgmt0
%doc Changelog README COPYING
%dir %_sysconfdir/vde2/libvdemgmt
%_libdir/libvdemgmt.so.0
%_libdir/libvdemgmt.so.0.0.1
%config %_sysconfdir/vde2/libvdemgmt/asyncrecv.rc
%config %_sysconfdir/vde2/libvdemgmt/closemachine.rc
%config %_sysconfdir/vde2/libvdemgmt/openmachine.rc
%config %_sysconfdir/vde2/libvdemgmt/sendcmd.rc

%files -n libvdeplug3
%doc Changelog README COPYING COPYING.libvdeplug
%_libdir/libvdeplug.so.3
%_libdir/libvdeplug.so.3.0.1

%files -n libvdesnmp0
%doc Changelog README COPYING
%_libdir/libvdesnmp.so.0
%_libdir/libvdesnmp.so.0.0.1

%files -n libvdehist-devel
%doc Changelog README COPYING
%_includedir/libvdehist.h
%_libdir/libvdehist.so
%_pkgconfigdir/vdehist.pc

%files -n libvdemgmt-devel
%doc Changelog README COPYING
%_includedir/libvdemgmt.h
%_libdir/libvdemgmt.so
%_pkgconfigdir/vdemgmt.pc

%files -n libvdeplug-devel
%doc Changelog README COPYING
%_includedir/libvdeplug.h
%_includedir/libvdeplug_dyn.h
%_libdir/libvdeplug.so
%_pkgconfigdir/vdeplug.pc

%files -n libvdesnmp-devel
%doc Changelog README COPYING
%_includedir/libvdesnmp.h
%_libdir/libvdesnmp.so
%_pkgconfigdir/vdesnmp.pc

%changelog
