%define _unpackaged_files_terminate_build 1
%define app_id com.odnoyko.valot

Name: valot
Version: 0.8.4
Release: alt2

Summary: A modern time tracking application built with GTK4 and Adwaita.
License: MIT
Group: Office
Url: https://gitlab.com/Valo27/valot
Vcs: https://gitlab.com/Valo27/valot

Source: %name-%version.tar

Requires: libgjs
Requires: typelib(Adw) = 1
Requires: typelib(Gda) = 6.0
Requires: libgda6-providers

BuildRequires(pre): rpm-macros-meson rpm-build-gir
BuildRequires: meson gtk-doc
BuildRequires: libgjs-devel
BuildRequires: blueprint-compiler

%description
Valot is designed for developers, freelancers, and professionals.
It offers a modern interface that follows GNOME Human Interface Guidelines.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%app_id
%_desktopdir/%app_id.desktop
%_iconsdir/hicolor/symbolic/apps/%app_id-symbolic.svg
%_iconsdir/hicolor/scalable/apps/%{app_id}*.svg
%_datadir/%name/
%_datadir/dbus-1/services/%app_id.service
%_datadir/glib-2.0/schemas/%app_id.gschema.xml
%_datadir/metainfo/%app_id.metainfo.xml
%_datadir/%app_id/screenshots/*.png
%doc README*

%changelog
