Name: v4l-utils
Version: 1.32.0
Release: alt1

Summary: Collection of video4linux support libraries and utilities
License: GPLv2+
Group: Video
Url: http://linuxtv.org

Provides: edid-decode = %EVR
Obsoletes: edid-decode

Source: %name-%version-%release.tar

BuildRequires: gcc-c++ meson
BuildRequires: libalsa-devel libGLU-devel libjpeg-devel libjson-c-devel
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: qt6-base-devel qt6-5compat-devel qt6-declarative-devel

%package -n ir-keytable
Summary: IR keytable management tool
Group: System/Kernel and hardware
Conflicts: v4l-utils < 0.8.2-alt1

%package -n libv4l
Summary: video4linux support libraries
Group: System/Libraries
License: LGPLv2+

%package -n libv4l-devel
Summary: Development files for libv4l
Group: Development/C
Requires: libv4l = %version-%release
License: LGPLv2+

%package -n qv4l2
Summary: A test bench application for video4linux devices
Group: Video

%package -n qvidcap
Summary: A video capture viewer
Group: Video

%description
Linux V4L2 and DVB API utilities.

%description -n ir-keytable
ir-keytable  is a tool that lists the Remote Controller devices, allows
to get/set IR keycode/scancode tables, test events generated by IR, and
to adjust other Remote Controller options.

%description -n libv4l
libv4l is a collection of libraries which adds a thin abstraction layer on
top of video4linux2 devices. The purpose of this (thin) layer is to make it
easy for application writers to support a wide variety of devices without
having to write separate code for different devices in the same class. libv4l
consists of 3 different libraries: libv4lconvert, libv4l1 and libv4l2.

libv4lconvert offers functions to convert from any (known) pixelformat
to V4l2_PIX_FMT_BGR24 or V4l2_PIX_FMT_YUV420.

libv4l1 offers the (deprecated) v4l1 API on top of v4l2 devices, independent
of the drivers for those devices supporting v4l1 compatibility (which many
v4l2 drivers do not).

libv4l2 offers the v4l2 API on top of v4l2 devices, while adding for the
application transparent libv4lconvert conversion where necessary.

%description -n libv4l-devel
The libv4l-devel package contains libraries and header files for
developing applications that use libv4l.

%description -n qv4l2
The qv4l2 tool is used to test video4linux capture devices, either
video, vbi or radio. This application can also serve as a generic
video/TV viewer application.

%description -n qvidcap
The qvidcap tool is used to test video4linux capture devices, either
using a video device, a file, or over network. This application can
also serve as a generic video/TV viewer application.

%prep
%setup

%build
%meson -Dgconv=disabled
%meson_build

%install
%meson_install

%files
%doc ChangeLog COPYING README.*

%_sbindir/*
%_bindir/*
%exclude %_bindir/ir-keytable
%exclude %_bindir/qv4l2
%exclude %_bindir/qvidcap
%_man1dir/cec-compliance.1*
%_man1dir/cec-ctl.1.*
%_man1dir/cec-follower.1*
%_man1dir/ir-ctl.1*
%_man1dir/dvb-fe-tool.1*
%_man1dir/dvb-format-convert.1*
%_man1dir/dvbv5-scan.1*
%_man1dir/dvbv5-zap.1*
%_man1dir/edid-decode.1*
%_man1dir/v4l2-compliance.1*
%_man1dir/v4l2-ctl.1*
%_man1dir/v4l2-tracer.1*

%files -n ir-keytable
%config(noreplace) %_sysconfdir/rc_maps.cfg
%_udevdir/rules.d/70-infrared.rules
%_udevdir/rc_keymaps
%_bindir/ir-keytable
%_man1dir/ir-keytable.1*
%_man5dir/rc_keymap.5*

%files -n libv4l
%doc COPYING.libv4l ChangeLog README.libv4l TODO
%_libdir/libv4l*.so.*
%_libdir/libdvbv5.so.*
%_libdir/libv4l

%files -n libv4l-devel
%doc README.lib-multi-threading
%_includedir/libv4l*.h
%_includedir/libdvbv5
%_libdir/libv4l*.so
%_libdir/libdvbv5.so
%_pkgconfigdir/*.pc

%files -n qv4l2
%_bindir/qv4l2
%_desktopdir/qv4l2.desktop
%_iconsdir/hicolor/*/*/qv4l2.*
%_man1dir/qv4l2.1*

%files -n qvidcap
%_bindir/qvidcap
%_desktopdir/qvidcap.desktop
%_iconsdir/hicolor/*/*/qvidcap.*
%_man1dir/qvidcap.1*

%changelog
