Name: url_handler
Version: 0.3.1
Release: alt1

Group: Networking/Other
Summary: Opens URLs of common types with dedicated programs
Summary(ru_RU.UTF-8): Открывает URL-ы обычных типов предназначенными для них программами
License: GPLv2+
BuildArch: noarch

# There was a single pkg before: it used to unite urlview & url_handler.
Conflicts: urlview < 0:0.9-ipl8mdk

# url_handler.sh uses tr:
Requires: coreutils

# Probably something like this should be present, but not now.
#Requires: webclient
# Now very few pkgs provide webclient.

# We use 'mailx' command not present in older mailx
Conflicts: mailx < 0:8.1.2-alt1

# 2 scripts of our own.
Source: url_handler-%version.tar

%define confdir %_sysconfdir/urlview

%description
url_handler can be used as a uniform centralized handler for URLs of
common types by other programs (e.g., urlview) or human users.
It has a configurable list of programs dedicated to handling each specific
URL type: it is initialized to the list of the most popular programs.

Examples:

\#1
url_handler.sh http://lrn.ru \# open it in a browser

\#2
url_handler.sh ./manual.html \# view the local file from the working dir

%description -l ru_RU.UTF-8
url_handler может быть использован другими программами (например,
urlview) или людьми-пользователями для единообразной централизованной
обработки URL-ов обычных типов.  Имеется настраиваемый список программ,
предназначенных для обработки каждого отдельного типа URL: изначально
установлен список, перечисляющий самый популярные программы.

Примеры:

\#1
url_handler.sh http://lrn.ru \# открыть сайт в браузере

\#2
url_handler.sh ./manual.html \# посмотреть локальный файл из рабочей директории

%prep
%setup

%install
mkdir -p "%buildroot"{%_bindir,%confdir}
install -pm755 url_handler.sh "%buildroot"%_bindir/
ln -s ../..%_bindir/url_handler.sh "%buildroot"%confdir/url_handler.sh
install -pm644 url_handlers "%buildroot"%confdir/

%files
%_bindir/*
%dir %confdir/
%confdir/url_handler.sh
%config(noreplace) %confdir/url_handlers

%changelog
