%define _libexecdir %_prefix/libexec
%define xdg_name org.freedesktop.UPower
%define namespace UPowerGlib
%define api_ver 1.0

%def_enable gtk_doc
%ifarch %ix86
%def_disable check
%else
%def_disable check
%endif

%def_enable man
%def_enable installed_tests

Name: upower
Version: 1.91.0
Release: alt1

Summary: Power Management Service
License: GPL-2.0-or-later
Group: System/Servers
Url: http://cgit.freedesktop.org/upower/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Vcs: https://gitlab.freedesktop.org/upower/upower.git

Provides: DeviceKit-power = 016
Obsoletes: DeviceKit-power < 016
Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch: %name-%version-%release.patch

%define glib_ver 2.66
%define gudev_ver 238
%define imobiledevice_ver 1.3
%define plist_ver 2.2.0
%define dbusmock_ver 0.23.1

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-python3 rpm-build-systemd
BuildRequires: meson libgio-devel >= %glib_ver
BuildRequires: gtk-doc libgudev-devel >= %gudev_ver
BuildRequires: libpolkit-devel libudev-devel gobject-introspection-devel
BuildRequires: libimobiledevice-devel > %imobiledevice_ver pkgconfig(libplist-2.0) pkgconfig(systemd)
%{?_enable_check:BuildRequires: /proc /dev/pts python3 python3-module-dbusmock >= %dbusmock_ver
BuildRequires: python3-module-packaging libumockdev-gir python3-module-dbus}

%description
UPower provides a daemon, API and command line tools for
managing power devices attached to the system.

%package -n lib%name
Summary: %name libraries
Group: System/Libraries
Provides: libdevkit-power = 016
Obsoletes: libdevkit-power < 016

%description -n lib%name
Libraries for %name

%package -n lib%name-devel
Summary: Development libraries and headers for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: libdevkit-power-devel = 016
Obsoletes: libdevkit-power-devel < 016

%description -n lib%name-devel
Headers, libraries and API docs for %name

%package -n lib%name-gir
Summary: GObject introspection data for the UPower library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libdevkit-power-gir = 016
Obsoletes: libdevkit-power-gir < 016

%description -n lib%name-gir
GObject introspection data for the UPower library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the UPower library
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR
Provides: libdevkit-power-gir-devel = 016
Obsoletes: libdevkit-power-gir-devel < 016

%description -n lib%name-gir-devel
GObject introspection devel data for the UPower library

%package tests
Summary: UPower testing programms
Group: System/Servers
Requires: %name = %EVR
Requires: lib%name-gir = %EVR

%description tests
This package provides UPower integration tests.

%prep
%setup
%patch -p1

%build
%meson \
    %{subst_enable_meson_bool gtk_doc gtk-doc} \
    %{subst_enable_meson_bool man man} \
    %{subst_enable_meson_bool installed_tests installed_tests}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%doc AUTHORS NEWS README*
%dir %_sysconfdir/UPower
%dir %_sysconfdir/UPower/UPower.conf.d
%doc %_sysconfdir/UPower/UPower.conf.d/README.md
%_sysconfdir/UPower/*.conf
%_unitdir/%name.service
%_udev_hwdbdir/60-%name-battery.hwdb
%_udevhwdbdir/95-upower-hid.hwdb
%_udevrulesdir/*.rules
%_bindir/%name
%_libexecdir/%{name}d
%_datadir/dbus-1/system.d/%xdg_name.conf
%_datadir/dbus-1/system-services/%xdg_name.service
%_datadir/polkit-1/actions/org.freedesktop.upower.policy
%{?_enable_man:
%_man1dir/%name.1*
%_man7dir/UPower.7*
%_man8dir/%{name}d.8*}
%_datadir/zsh/site-functions/_upower
%dir %_var/lib/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/dbus-1/interfaces/*.xml
%{?_enable_gtk_doc:%_datadir/gtk-doc/html/*}

%files -n lib%name-gir
%_typelibdir/%namespace-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/%namespace-%api_ver.gir

%if_enabled installed_tests
%files tests
%_datadir/installed-tests/%name/%name-integration.test
%_libexecdir/%name/integration-test.py
%_libexecdir/%name/output_checker.py
%_libexecdir/%name/tests/
%endif

%changelog
