Name: u-boot-rpi3
Version: 2025.10
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: https://docs.u-boot.org/en/latest/

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

Source: %name-%version-%release.tar

BuildRequires: aarch64-none-elf-gcc
BuildRequires: bc dtc >= 1.4 flex libgnutls-devel libssl-devel libuuid-devel

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports Raspberry Pi 3/4 boards.

%define rpis rpi_3 rpi_3_b_plus rpi_4 rpi_arm64
%define img kernel8.img

%prep
%setup

%build
export DTC=%_bindir/dtc
export CROSS_COMPILE=aarch64-none-elf-
for board in %rpis; do
	O=build/${board}
	%make_build O=${O} ${board}_defconfig all
	install -pm0644 -D ${O}/u-boot.bin out/${board}/%img
done

%install
mkdir -p %buildroot%_datadir/u-boot
cp -a out/* %buildroot%_datadir/u-boot

%files
%doc README doc/board/broadcom
%_datadir/u-boot/*

%changelog
