Name: tuxmath
Group: Games/Other
Version: 2.0.3
Release: alt7
Summary: Educational math tutor for children

License: GPLv3 AND CC-BY-SA-3.0 AND OFL-1.1
Url: https://github.com/tux4kids/tuxmath
Source0: %name-%version.tar
Source1: %name.appdata.xml
Patch0: tuxmath-update-russian-po.patch
Patch1: tuxmath-2.0.3-alt-ftbfs.patch

BuildRequires: gcc-c++ libxml2-devel pkgconfig(cairo)
BuildRequires: desktop-file-utils libappstream-glib
BuildRequires: libSDL-devel
BuildRequires: libSDL_image-devel
BuildRequires: libSDL_mixer-devel
BuildRequires: libSDL_pango-devel
BuildRequires: libSDL_net-devel
BuildRequires: librsvg-devel librsvg-gir-devel
BuildRequires: t4k_common-devel
Requires: icon-theme-hicolor

%description
TuxMath is an educational math tutor for children. It features several
different types of gameplay, at a variety of difficulty levels.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%autoreconf
%add_optflags -fcommon
%configure
%make_build

%install
%makeinstall_std
%find_lang %name

desktop-file-install --vendor="" \
  --dir $RPM_BUILD_ROOT%_datadir/applications %name.desktop

mkdir -p $RPM_BUILD_ROOT%_datadir/icons/hicolor/48x48/apps
install -p -m 644 data/images/icons/icon.png \
  $RPM_BUILD_ROOT%_datadir/icons/hicolor/48x48/apps/%name.png

mkdir -p $RPM_BUILD_ROOT%_datadir/icons/hicolor/scalable/apps
install -p -m 644 data/images/icons/tuxmath.svg \
  $RPM_BUILD_ROOT%_datadir/icons/hicolor/scalable/apps

mkdir -p $RPM_BUILD_ROOT%_datadir/appdata
install -p -m 644 %SOURCE1 $RPM_BUILD_ROOT%_datadir/appdata
appstream-util validate-relax --nonet \
  $RPM_BUILD_ROOT%_datadir/appdata/%name.appdata.xml

%files -f %name.lang
%_docdir/%name
%_bindir/%{name}*
%_bindir/generate_lesson
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/appdata/%name.appdata.xml
%_datadir/applications/%name.desktop
%_datadir/icons/hicolor/48x48/apps/%name.png
%_datadir/icons/hicolor/scalable/apps/%name.svg

%changelog
