%define import_path github.com/trufflesecurity/trufflehog/v3
%global _unpackaged_files_terminate_build 1

Name: trufflehog
Version: 3.91.0
Release: alt1
Summary: CLI tool to find exposed secrets in source and archives

Group: Development/Tools
License: AGPL-3.0

Url: https://trufflesecurity.com/
Vcs: https://github.com/trufflesecurity/trufflehog.git

Source0: %name-%version.tar
Source1: %name-%version-vendor.tar

ExclusiveArch: %go_arches
ExcludeArch: %ix86

BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang

%description
TruffleHog is a scanning engine that helps find exposed secrets
within e.g. GitHub/GitLab repos, AWS S3 buckets, GCS buckets,
Docker images, Circle CI/Travis CI setups, or in individual files.

%prep
%setup -a1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export LDFLAGS="-X %import_path/pkg/version.BuildVersion=%version"
%golang_prepare
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1

%golang_install

%files
%_bindir/%name
%doc *.md

%changelog
