%define _unpackaged_files_terminate_build 1
%set_verify_elf_method unresolved=relaxed

%def_without separate_trikruntime
%def_without sanitize
%def_without debug
%define appname trik-studio

Name: trikStudio
Version: 2025.4
Release: alt1
Summary: Intuitive programming environment robots
Summary(ru_RU.UTF-8): Интуитивно-понятная среда программирования роботов
License: Apache-2.0
Group: Education
Url: https://github.com/trikset/trik-studio

Source: %name-%version.tar
Patch: %name-%version-alt.patch
Patch1: gamepad.patch
Patch2: alt-ftbfs.patch
Patch3: fix-build-with-qt5-quazip1.patch
Patch5: quazip.patch
Patch6: Box2D.patch

BuildRequires: gcc-c++ qt5-base-devel qt5-svg-devel qt5-script-devel qt5-multimedia-devel libusb-devel libudev-devel libgmock-devel chrpath
BuildRequires: libqscintilla2-qt5-devel zlib-devel python3-dev libhidapi-devel quazip-qt5-devel qt5-serialport-devel p7zip-standalone
# Workaround due project build with -fsanitize=undefined natively
# https://bugzilla.altlinux.org/show_bug.cgi?id=38106
#if_with sanitize
%ifnarch %e2k
BuildRequires: libubsan-devel-static
%endif
#endif
BuildRequires: rsync qt5-tools

Requires: libqscintilla2-qt5-devel pythonqt-devel
Requires: libhidapi lego-mindstorms-udev-rules
Requires: %name-data = %version-%release
Conflicts: lib%name

%description
Intuitive programming environment allows you to program robots using a sequence
of pictures. With TRIK Studio programming is easy and fun.

TRIK Studio perfectly as universal for teaching programming, provided the
transition from the chart to the textual programming language that is planned to
implement the language of block diagrams. The environment is also implemented
programming robots Lego Mindsorms NXT 2.0 and EV3, but the possibility of such
robots are very limited in comparison with the TRIK.

%description -l ru_RU.UTF-8
Интуитивно-понятная среда программирования позволяет программировать роботов с
помощью последовательности картинок. С TRIK Studio программирование становится
простым и увлекательным.

TRIK Studio прекрасно подходит как универсальное ПО преподавания основ
программирования, предусмотрен переход от диаграмм к текстовым языкам
программирования, планируется реализация языка блок-схем. В среде также
реализовано программирование роботов Lego Mindsorms NXT 2.0 и EV3, но
возможности таких роботов сильно ограничены в сравнении с ТРИК.

%package data
Summary: Data files for %name
Group: Education
BuildArch: noarch

%description data
Data files for %name

%package -n trikRuntime
Summary: Trik runtime libraries for %name
Group: Education
BuildArch: noarch

%description -n trikRuntime
Trik runtime libraries for %name

%package -n trikRuntime-devel
Summary: Trik runtime development files for %name
Group: Education
BuildArch: noarch

%description -n trikRuntime-devel
Trik runtime development files for %name

%prep
%setup
%patch -p1
%patch6 -p1
%ifarch %e2k
# workaround of SIGILL in ecf_opt64 from LCC 1.25.23
sed -i "s/QOverload<QObject\*>::of/(void(*)(QObject*))/" qrkernel/settingsListener.h
%endif
sed -e '2 a export LD_LIBRARY_PATH=%_libdir\/%name\/' -i installer/platform/trikStudio.sh
sed -e 's|^trik-studio|%_libdir/%name/trik-studio|' -i installer/platform/trikStudio.sh

tar -xf ./.gear/Box2D.tar.bz2
tar -xf ./.gear/trikRuntime.tar.bz2
tar -xf ./.gear/gamepad.tar.bz2
tar -xf ./.gear/qt-solutions.tar.bz2
tar -xf ./.gear/qslog.tar.bz2
tar -xf ./.gear/checkapp.tar.bz2
rm -rf qscintilla quazip

# Hot fix for python3.13
find . -name PythonQt.cpp | xargs sed -i '/PyEval_ThreadsInitialized/,+2d'
find . -name pythonEngineWorker.cpp | xargs sed -i '/Py_SetPath/d'

pushd thirdparty/gamepad
%patch1
popd

%patch5 -p1

%ifarch loongarch64 riscv64
# gold does not work on these architectures
sed -e '/use_gold_linker/d' -i \
    global.pri \
    plugins/robots/thirdparty/trikRuntime/trikRuntime/global.pri
%endif

%build
export PYTHON_VERSION=$(python3 --version | cut -d' ' -f2 | cut -d. -f1-2)
%qmake_qt5 -r \
    CONFIG+=use_system_quazip1-qt5 \
%if_with debug
    CONFIG+=debug CONFIG-=release \
%else
    CONFIG-=debug CONFIG+=release \
%endif
%ifarch %e2k
    CONFIG+=noPch CONFIG+=warn_off \
%endif
    QMAKE_LFLAGS+=-Wl,-rpath-link=%_builddir/%name-%version/bin \
    QMAKE_LFLAGS+=-Wl,--disable-new-dtags \
    QMAKE_LFLAGS+=-Wl,-rpath=%_libdir/%name \
    CONFIG+=no_rpath \
%if_with sanitize
    CONFIG+=!nosanitizers \
%endif
    PREFIX=%_prefix LIBDIR=%_libdir TRIK_STUDIO_VERSION=%version studio.pro

%make_build

%install
export PYTHON_VERSION=$(python3 --version | cut -d' ' -f2 | cut -d. -f1-2)

for N in Kernel Network Hal Control ScriptRunner RuntimeQsLog Communicator; do
    [ -e bin/libtrik${N}.la ] || ln -sf libtrik${N}.so bin/libtrik${N}.la ||:
    [ -e bin/trik${N}.pc ] || echo > bin/trik${N}.pc ||:
done

%make_install INSTALL_ROOT=%buildroot install
mv %buildroot%_libdir/*.so* %buildroot%_libdir/%name
mv %buildroot%_bindir/trik-studio %buildroot%_libdir/%name/
ln -fs %name %buildroot%_bindir/trik-studio
%if_with separate_trikruntime
mv %buildroot%_prefix/lib/libqslog*.so* %buildroot%_libdir
mv %buildroot%_prefix/lib/libtrik*.so* %buildroot%_libdir
%else
rm -rf %buildroot%_sysconfdir/trik
rm -f %buildroot%_prefix/lib/libqslog*.so*
rm -f %buildroot%_prefix/lib/libtrik*.so*
rm -rf %buildroot%_datadir/trikRuntime
rm -rf %buildroot%_prefix/local/share/qslog/
rm -rf %buildroot%_includedir/trik*
rm -rf %buildroot%_includedir/qslog*
rm -rf %buildroot%_includedir/QsLog*
%endif
rm -f %buildroot%_libdir/**.pc
rm -f %buildroot%_prefix/lib/**.pc
rm -f %buildroot/lib/trikPythonQt*.pc
rm -f %buildroot/lib/libtrikPythonQt*.so*
rm -f %buildroot/lib/*PythonQt_QtAll* %buildroot/include/PythonQt_QtAll.h
rm -f %buildroot%_libdir/%name/plugins/tools/kitPlugins/librobots-null-interpreter.so
rm -rf %buildroot/include/PythonQt*
rm -rf %buildroot/include/com_trolltech*.h
rm -rf %buildroot%_includedir/qt5/Qsci
rm -rf %buildroot%_datadir/qt5/qsci/

pushd bin
for d in examples help translations images; do
    cp -fr $d %buildroot%_datadir/%name/
done
#cp -fr trikSharp %buildroot%_libdir/%name/
cp -f gamepad %buildroot%_bindir/
mv -f %buildroot/opt/checkapp/bin/checkapp %buildroot%_bindir/
mkdir -p %buildroot%_datadir/%name/languages

popd

find %buildroot%_libdir/%name -name 'libtrikScriptRunner.so.*' -type f -exec chrpath -r %_libdir/%name {} \;
find %buildroot%_libdir/%name -name 'libtrikPythonQt_QtAll-Qt515-Python3.*.so.*' -type f -exec chrpath -r %_libdir/%name {} \;

%files
%_bindir/*
%_libdir/%name
%_sysconfdir/%appname.config

%files data
%_datadir/%name
%_miconsdir/*
%_liconsdir/*
%_niconsdir/*
%_desktopdir/*
%doc LICENSE NOTICE README.md

%if_with separate_trikruntime
%files -n trikRuntime
%_sysconfdir/trik
%_libdir/libqslog*.so.*
%_libdir/libtrik*.so.*
%_datadir/trikRuntime

%files -n trikRuntime-devel
%_libdir/libqslog*.so
%_libdir/libtrik*.so
%_includedir/trik*
%_includedir/qslog*
%_includedir/QsLog*
%endif

%changelog
