%global import_path github.com/traefik/traefik

%global _unpackaged_files_terminate_build 1
%def_with prebuild_webui

Name: traefik
Version: 3.5.6
Release: alt1
Summary: The Cloud Native Edge Router

License: MIT
Group: System/Servers
Url: https://traefik.io/
Vcs: https://github.com/traefik/traefik.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-macros-golang rpm-macros-nodejs
BuildRequires: rpm-build-golang golang >= 1.24.0
%if_without prebuild_webui
BuildRequires: npm yarn
BuildRequires: node node-devel node-gyp node-sass
%endif

%description
Traefik listens to your service registry/orchestrator API and instantly
generates the routes so your microservices are connected to the outside
world -- without further intervention from your part.

Traefik is a modern HTTP reverse proxy and load balancer that makes
deploying microservices easy. Traefik integrates with your existing
infrastructure components (Docker, Swarm mode, Kubernetes, Marathon,
Consul, Etcd, Rancher, Amazon ECS, ...) and configures itself
automatically and dynamically.

Pointing Traefik at your orchestrator should be the only configuration
step you need.

Documentation: http://docs.traefik.io/

%prep
#%%if_without prebuild_webui
# Build the Front-end Assets
# $ cd webui
# $ git rm -r node_modules
# $ npm install
# $ rm -rf node_modules/node-sass
# $ rm -rf node_modules/node-gyp
# $ git add -f node_modules
# $ git commit -n --no-post-rewrite -m "add node js modules"
#%%endif

# Vendorized go modules
# $ go generate
# $ GO111MODULE=on go mod vendor -v
# $ git add -f vendor
# $ git commit -n --no-post-rewrite -m "add go vendor modules"

%setup
%patch -p1

%if_without prebuild_webui
rm -rf webui/static

# add symlink to node headers
node_ver=$(node -v | sed -e "s/v//")
mkdir -p webui/node_modules/.node-gyp/$node_ver/include
ln -s %_includedir/node webui/node_modules/.node-gyp/$node_ver/include/node
echo "9" > webui/node_modules/.node-gyp/$node_ver/installVersion

ln -sf %nodejs_sitelib/node-gyp webui/node_modules/node-gyp
ln -sf %nodejs_sitelib/node-sass webui/node_modules/node-sass
%else
rm -rf webui/node_modules
%endif

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export PATH="$PATH:$PWD/webui/node_modules/.bin"
export npm_config_devdir="$PWD/webui/node_modules/.node-gyp"

%golang_prepare

cd .gopath/src/%import_path

export VERSION=%version
export COMMIT=%release
export BRANCH=altlinux
export CODENAME=chabichou
export DATE=$(date -u '+%%Y-%%m-%%d')
export GOFLAGS="-mod=vendor"

%if_without prebuild_webui
pushd webui
yarn build:prod
echo 'For more information see `webui/readme.md`' > static/DONT-EDIT-FILES-IN-THIS-DIRECTORY.md
popd
%endif

mkdir -p dist

go generate
GOGC=off go build -ldflags " -w  \
    -X %import_path/v3/pkg/version.Version=$VERSION \
    -X %import_path/v3/pkg/version.Codename=$CODENAME \
    -X %import_path/v3/pkg/version.BuildDate=$DATE \
    -X main.version=$VERSION \
    -X main.commit=$COMMIT \
    -X main.branch=$BRANCH \
    " -o dist/traefik ./cmd/traefik

%install
install -p -D -m 0755 .gopath/src/%import_path/dist/traefik %buildroot%_bindir/%name
install -p -D -m 0644 contrib/systemd/traefik.service %buildroot%_unitdir/%name.service
install -d -m 750 %buildroot%_sysconfdir/%name
install -d -m 750 %buildroot%_sysconfdir/%name/%name.d
touch %buildroot%_sysconfdir/%name/acme.json
install -p -D -m 0644 traefik.sample.toml %buildroot%_sysconfdir/%name/%name.toml
install -p -D -m 0644 traefik.sample.yml %buildroot%_sysconfdir/%name/%name.yml
# Setup directories
install -d -m 755 %buildroot%_logdir/%name
install -d -m 755 %buildroot%_sharedstatedir/%name
# Install logrotate
#install -p -D -m 644 %%SOURCE10 %%buildroot%%_logrotatedir/%%name

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -g %name -G %name -c 'Traefik reverse proxy and load balancer daemon' \
        -s /sbin/nologin  -d %_sharedstatedir/%name %name 2>/dev/null ||:
%post
%post_service %name

%preun
%preun_service %name

%files
%doc LICENSE.md
%_bindir/%name
%dir %attr(750, root, %name) %_sysconfdir/%name
%dir %attr(750, root, %name) %_sysconfdir/%name/%name.d
%config(noreplace) %attr(640, root, %name) %_sysconfdir/%name/%name.toml
%config(noreplace) %attr(640, root, %name) %_sysconfdir/%name/%name.yml
%config(noreplace) %attr(600, %name, %name) %_sysconfdir/%name/acme.json
%_unitdir/%name.service
%dir %attr(0770, root, %name) %_logdir/%name
%dir %attr(0750, %name, %name) %_sharedstatedir/%name

%changelog
