%def_without nautilus
%def_with caja

Name: tortoisehg
Version: 7.0.1
Release: alt1

Summary: Mercurial GUI command line tool thg

License: GPLv2
# - few files are however under the more permissive GPLv2+
Group: Development/Other
Url: https://tortoisehg.bitbucket.io

Source: %name-%version.tar

Packager: Grigory Ustinov <grenka@altlinux.org>

Requires: python3-module-iniparse mercurial
Requires: python3-module-PyQt5 python3-module-qscintilla2-qt5 python3-module-Pygments
Requires: python3-module-pygobject3

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: mercurial
BuildRequires: gettext python3-module-sphinx python3-module-PyQt5
BuildRequires: desktop-file-utils libappstream-glib

BuildArch: noarch

%add_python3_req_skip _winreg pythoncom comtypes comtypes.automation comtypes.client

%description
This package contains the thg command line tool, which provides a graphical
user interface to the Mercurial distributed revision control system.

%if_with caja
%package caja
Summary: Mercurial GUI plug-in to the Caja file manager
Group: Development/Other
Requires: %name = %EVR, python3-module-caja
Requires: gnome-icon-theme mate-icon-theme
Requires: /usr/bin/caja

%description caja
This package contains the TortoiseHg MAT/Caja extension, which makes the
Mercurial distributed revision control system available in the file manager
with a graphical interface.
%endif

%if_with nautilus
%package nautilus
Summary: Mercurial GUI plug-in to the Nautilus file manager
Group: Development/Other
Requires: %name = %EVR, python3-module-nautilus

%description nautilus
This package contains the TortoiseHg Gnome/Nautilus extension, which makes the
Mercurial distributed revision control system available in the file manager
with a graphical interface.

Note that the nautilus extension has been deprecated upstream.
%endif

%prep
%setup

cat > tortoisehg/util/config.py << EOT
bin_path     = "%_bindir"
license_path = "%_defaultdocdir/COPYING.txt"
locale_path  = "%_datadir/locale"
icon_path    = "%_datadir/pixmaps/tortoisehg/icons"
nofork       = True
EOT

%build
%pyproject_build

%make SPHINXBUILD="sphinx-build-3" -C doc html

%install
%pyproject_install
rm %buildroot%python3_sitelibdir/hgext3rd/__init__.*

mkdir -p %buildroot%_sysconfdir/mercurial/hgrc.d
install -pm0644 contrib/mergetools.rc %buildroot%_sysconfdir/mercurial/hgrc.d/thgmergetools.rc

desktop-file-install --dir=%buildroot%_datadir/applications contrib/thg.desktop

rm -f %buildroot/%_datadir/doc/tortoisehg/COPYING.txt

%if_with caja
mkdir -p %buildroot%_datadir/caja-python/extensions/
cp -v %buildroot%_datadir/nautilus-python/extensions/nautilus-thg.py* %buildroot%_datadir/caja-python/extensions/caja-thg.py
%endif

%if_without nautilus
rm -rf %buildroot%_datadir/nautilus-python/extensions/nautilus-thg.py*
%endif

%find_lang %name

%files -f %name.lang
%doc doc/build/html/ COPYING.txt
%config(noreplace) %_sysconfdir/mercurial/hgrc.d/thgmergetools.rc
%_bindir/thg
%python3_sitelibdir/hgext3rd
%python3_sitelibdir/tortoisehg
%python3_sitelibdir/tortoisehg-%version.dist-info
%_datadir/pixmaps/tortoisehg
%_datadir/pixmaps/thg_logo.svg
%_datadir/applications/thg.desktop

%if_with nautilus
%files nautilus
%_datadir/nautilus-python/extensions/nautilus-thg.py*
%endif

%if_with caja
%files caja
%_datadir/caja-python/extensions/caja-thg.py*
%endif

%changelog
