%define java_home %_jvmdir/jre

Group: System/Libraries
BuildRequires: /proc rpm-build-java
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           tomcat-native
Epoch:          1
Version:        1.2.35
Release:        alt1_2jpp11
Summary:        Tomcat native library

License:        Apache-2.0
URL:            http://tomcat.apache.org/tomcat-8.0-doc/apr.html
Source0:        http://www.apache.org/dist/tomcat/tomcat-connectors/native/%{version}/source/%{name}-%{version}-src.tar.gz

BuildRequires:  gcc-c++
BuildRequires:  jpackage-17-compat
BuildRequires:  libapr1-devel >= 1.4.3
BuildRequires:  libssl-devel >= 1.0.2
# Upstream compatibility:
Provides:       tcnative = %{version}-%{release}
Source44: import.info

%description
Tomcat can use the Apache Portable Runtime to provide superior
scalability, performance, and better integration with native server
technologies.  The Apache Portable Runtime is a highly portable library
that is at the heart of Apache HTTP Server 2.x.  APR has many uses,
including access to advanced IO functionality (such as sendfile, epoll
and OpenSSL), OS level functionality (random number generation, system
status, etc), and native process handling (shared memory, NT pipes and
Unix sockets).  This package contains the Tomcat native library which
provides support for using APR in Tomcat.


%prep
%setup -q -n %{name}-%{version}-src
f=CHANGELOG.txt ; iconv -f iso-8859-1 -t utf-8 $f > $f.utf8 ; mv $f.utf8 $f


%build
cd native
%configure \
    --with-apr=%{_bindir}/apr-1-config \
    --with-java-home=%{java_home}
%make_build


%install
make -C native install DESTDIR=$RPM_BUILD_ROOT
# Perhaps a devel package sometime?  Not for now; no headers are installed.
rm -f $RPM_BUILD_ROOT%{_libdir}/libtcnative*.*a
rm -rf $RPM_BUILD_ROOT%{_libdir}/pkgconfig
rm -rf ${RPM_BUILD_ROOT}%{_includedir}/*.h


%files
%{!?_licensedir:%global license %%doc}
%doc --no-dereference LICENSE NOTICE
%doc CHANGELOG.txt TODO.txt
# Note: unversioned *.so needed here due to how Tomcat loads the lib :(
%{_libdir}/libtcnative*.so*


%changelog
