%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Summary: Terminal multiplexer
Name: tmux
Version: 3.5a
Release: alt1
License: ISC and BSD-3-Clause and BSD-2-Clause
Group: Terminals
Url: https://tmux.github.io/
Vcs: https://github.com/tmux/tmux

Source0: http://downloads.sourceforge.net/%name/%name-%version.tar.gz
Source1: bash_completion_tmux.sh
BuildRequires: libevent-devel >= 2.0
BuildRequires: libncurses-devel
BuildRequires: libutempter-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: /proc /dev/pts
}}

%description
tmux is a terminal multiplexer: it enables a number of terminals to
be created, accessed, and controlled from a single screen. tmux may
be detached from a screen and continue running in the background, then
later reattached.

%prep
%setup
%autopatch -p1

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --enable-utempter
%make_build

%install
%makeinstall_std
install -Dpm 644 %SOURCE1 %buildroot%_datadir/bash-completion/completions/tmux

%check
# We have default TERM=screen-256color
sed -i 's/screen/screen-256color/' regress/new-session-environment.sh
# No need to wait.
sed -i '/sleep/d' regress/Makefile
# Known failure for us.
rm regress/capture-pane-hyperlink.sh
make -C regress

%files
%doc CHANGES README COPYING example_tmux.conf
%_bindir/*
%_man1dir/*
%_datadir/bash-completion/completions/tmux

%changelog
