%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%def_with python

Name: tbb
Version: 2022.1.0
Release: alt2
Summary: Threading Building Blocks
License: Apache-2.0
Group: Development/Tools
Url: https://github.com/oneapi-src/oneTBB
VCS: https://github.com/oneapi-src/oneTBB.git
Source: %name-%version.tar
# Elbrus support
Patch2000: tbb-e2k.patch

Requires: lib%name = %EVR

%if_with python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif
BuildRequires: gcc-c++
BuildRequires: libgomp-devel
%if_with python
BuildRequires: python3-dev python3-module-setuptools python3-module-wheel
%endif
BuildRequires: swig
BuildRequires: cmake ctest
# needed for some tests
BuildRequires: /proc

%description
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

%package -n lib%name
Summary: Shared libraries of Threading Building Blocks
Group: Development/C++

%description -n lib%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains shared libraries of Threading Building Blocks.

%package devel
Summary: Development libraries and headers of Threading Building Blocks
Group: Development/C++
Requires: lib%name = %EVR
Requires: %name-headers = %EVR
Provides: lib%name-devel = %EVR
Conflicts: lib%name-devel < %EVR
Obsoletes: lib%name-devel
Provides: %name-headers = %EVR
Conflicts: %name-headers < %EVR
Obsoletes: %name-headers

%description devel
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains development libraries for Threading Building
Blocks.

%package examples
Summary: Examples for Threading Building Blocks
Group: Development/Documentation
Requires: lib%name = %EVR
BuildArch: noarch

%description examples
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains examples for Threading Building Blocks.

%if_with python
%package -n python3-module-%name
Summary: Python 3 Threading Building Blocks module
Group: Development/Python3

%description -n python3-module-%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains python3 module for Threading Building Blocks.
%endif

%prep
%setup
%ifarch %e2k
%patch2000 -p1
%endif

%build
%add_optflags -D_FILE_OFFSET_BITS=64

export CFLAGS="${CFLAGS:-%optflags} -DDO_ITT_NOTIFY -DUSE_PTHREAD"
export CXXFLAGS="${CXXFLAGS:-%optflags} -DDO_ITT_NOTIFY -DUSE_PTHREAD"
export CPLUS_FLAGS="%{optflags} -DDO_ITT_NOTIFY -DUSE_PTHREAD"
export LDFLAGS="${LDFLAGS:-} -lpthread"
export RPM_LD_FLAGS="${RPM_LD_FLAGS:-} -lpthread"
%ifarch riscv64
export LDFLAGS="${LDFLAGS:-} -latomic"
export RPM_LD_FLAGS="${RPM_LD_FLAGS:-} -latomic"
%endif

%cmake \
	-DCMAKE_CXX_STANDARD=14 \
	-DTBB_EXAMPLES:BOOL=ON \
	-DTBB_STRICT:BOOL=OFF \
	-DTBB4PY_BUILD:BOOL=OFF \
	%nil

%cmake_build

%install
%cmakeinstall_std
%if_with python
pushd python
export TBBROOT=%buildroot%_prefix
subst "s|tbb_root, 'lib'|tbb_root, '%_lib'|g" setup.py
subst "s|'irml'||" setup.py
subst 's|\(version[ \t]*=\)[ \t]*"0.2"|\1"%version"|' setup.py
%pyproject_build
%pyproject_install
popd
%endif

rm -f %buildroot%_defaultdocdir/TBB/README.md

# Fix pkgconfig compatibility by renaming tbb32.pc to tbb.pc for i586 architecture to maintain consistent naming across all platforms.
if [ -f "%buildroot%_pkgconfigdir/tbb32.pc" ];then
	mv "%buildroot%_pkgconfigdir/tbb32.pc" "%buildroot%_pkgconfigdir/tbb.pc"
fi



%ifnarch ppc64le aarch64 armh
%check
%cmake_build -t test
%endif

%files -n lib%name
%doc LICENSE.txt
%doc README.md
%_libdir/*.so.*

%files devel
%_includedir/oneapi
%_includedir/tbb
%_libdir/cmake/TBB
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%files examples
%doc examples

%if_with python
%files -n python3-module-%name
%python3_sitelibdir/TBB.py
%python3_sitelibdir/%{pyproject_distinfo %name}/
%python3_sitelibdir/tbb
%python3_sitelibdir/__pycache__/*
%endif

%changelog
