%def_with check

Name: task
Version: 3.4.2
Release: alt1

Summary: A command-line todo list manager
License: GPLv2+
Group: Office

Url: https://taskwarrior.org
Vcs: https://github.com/GothenburgBitFactory/taskwarrior.git
Source: %name-%version.tar
Source1: %name-%version-src-libshared.tar
Source2: vendor.tar
Source3: config.toml

Requires: zsh-completion-%name = %version-%release %name-core = %version-%release
# TODO Requires: vim-plugin-syntax

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake libuuid-devel rust-cargo corrosion
%if_with check
BuildRequires: ctest python3
%endif

# Only those two seem to be officially supported
ExclusiveArch: x86_64 aarch64

%description
Task is a command-line todo list manager. It has
support for GTD functionality and includes the
following features: tags, colorful tabular output,
reports and graphs, lots of manipulation commands,
low-level API, abbreviations for all commands and
options, multiuser file locking, recurring tasks.

This package includes zsh completion bindings.
# TODO and new vim stuff

%package core
Group: Office
Summary: Core distribution of taskwarrior
%description core
Task is a command-line todo list manager. It has
support for GTD functionality and includes the
following features: tags, colorful tabular output,
reports and graphs, lots of manipulation commands,
low-level API, abbreviations for all commands and
options, multiuser file locking, recurring tasks.

%package -n zsh-completion-task
Group: Shells
BuildArch: noarch
Summary: Zsh completion for taskwarrior
%description -n zsh-completion-task
Zsh completion for taskwarrior

%prep
%setup -a1 -a2
install -vpD %SOURCE3 .cargo/config.toml
# Check for non-source files
find vendor \( -name '*.a' -o -name '*.lib' -o -name '*.dll' \) | grep . && exit 1

%build
export CARGO_HOME="./.cargo"
%cmake -DSYSTEM_CORROSION=ON
%cmake_build

%install
%cmake_install
%find_lang %name
install -Dm 644 -T scripts/bash/task.sh %buildroot%_sysconfdir/bash_completion.d/task

%check
%cmake_build --target test_runner
%ctest

%files
%_sysconfdir/bash_completion.d/%name

%files core
%doc %_docdir/%name/*
%_bindir/task
%_man1dir/*
%_man5dir/*

%files -n zsh-completion-task
%_datadir/zsh/site-functions/_task

%changelog
