Name: t1lib
Version: 5.1.2
Release: alt8

Summary: Type 1 font rasterizer
License: LGPL
Group: System/Libraries

Url: ftp://sunsite.unc.edu/pub/Linux/libs/graphics/
# ftp://ibiblio.org/pub/Linux/libs/graphics/%name-%version.tar.gz
Source: %name-%version.tar
Source1: t1lib-CP1251.enc
Source2: t1lib-KOI8-R.enc
Source3: t1lib-KOI8-U.enc
Patch2: t1lib-5.1.2-alt-makefile-doc.patch
Patch3: t1lib-5.1.2-alt-config.patch
Patch4: t1lib-5.1.2-deb-alt-fixes.patch
Patch5: t1lib-c99.patch

# Patches from Gentoo
Patch100: t1lib-5.1.2-CVE-2010-2642_2011-0433_2011-5244.patch
Patch101: t1lib-5.1.2-CVE-2011-0764.patch
Patch102: t1lib-5.1.2-CVE-2011-1552_1553_1554.patch
Patch103: t1lib-5.1.2-format-security.patch

# Automatically added by buildreq on Sat May 10 2008
BuildRequires: imake libXaw-devel libXpm-devel texlive-context texlive-collection-latexrecommended xorg-cf-files libXext-devel
BuildPreReq: libSM-devel libXmu-devel

%def_disable static

%package x
Summary: Type 1 font rasterizer X.Org libraries
Group: System/Libraries
Requires: %name = %EVR

%package devel
Summary: Type 1 font rasterizer development files
Group: Development/C
Requires: %name = %EVR

%package devel-static
Summary: Type 1 font rasterizer static libraries
Group: Development/C
Requires: %name-devel = %EVR

%package utils
Summary: Utilities for manipulating Type 1 fonts
License: GPL
Group: Graphics
Requires: %name = %EVR

%description
T1lib is a library for generating character and string-glyphs from
Adobe Type 1 fonts under UNIX.  T1lib uses most of the code of the X11
rasterizer donated by IBM to the X11-project.  But some disadvantages of
the rasterizer being included in X11 have been eliminated.  T1lib also
includes a support for antialiasing.

%description x
T1lib is a library for generating character and string-glyphs from
Adobe Type 1 fonts under UNIX.
This package contains X.Org-dependent libraries.

%description devel
This package contains development files required for building
%name-based software.

%description devel-static
This package contains static libraries required for building
statically linked %name-based software.

%description utils
This package contains the programs "xglyph" and "type1afm"
It also contains the "t1libconfig" script used to configure %name.

%prep
%setup
%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1

%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p1

%build
autoconf
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' configure
%configure %{subst_enable static}
%make without_doc

pushd doc
	make clean
	make pdf
	bzip2 -9 t1lib_doc.pdf
popd

%install
%make_install DESTDIR=%buildroot install
mkdir -p %buildroot%_datadir/t1lib/enc
install -pm644 Fonts/enc/*  %buildroot%_datadir/%name/enc
install -pm644 %SOURCE1 %buildroot%_datadir/%name/enc/CP1251.enc
install -pm644 %SOURCE2 %buildroot%_datadir/%name/enc/KOI8-R.enc
install -pm644 %SOURCE3 %buildroot%_datadir/%name/enc/KOI8-U.enc

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 Changes README.t* doc/t1lib_doc.pdf.bz2 %buildroot%docdir/

%files
%_libdir/libt1.so.*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.config
%dir %_datadir/%name
%_datadir/%name/*
%dir %docdir
%doc %docdir/[A-Z]*

%files x
%_libdir/libt1x.so.*

%files devel
%_libdir/*.so
%_includedir/*
%dir %docdir
%doc %docdir/t1lib_doc.pdf.bz2

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%files utils
%_bindir/*

# TODO:
# - merge type1afm.1 manpage from debian patch

%changelog
