%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define ver_major 49
%define beta %nil
%define api_ver 6
%define service_ver 3
%define capture_ver 4
%define xdg_name org.gnome.Sysprof
%define _libexecdir %_prefix/libexec


%def_enable sysprofd
%def_enable gtk
%ifnarch %e2k
%def_enable libunwind
%endif

Name: sysprof
Version: %ver_major.0
Release: alt1%beta

Summary: Sysprof kernel based performance profiler for Linux
Group: Development/Tools
License: GPL-3.0-or-later
Url: http://sysprof.com

Vcs: https://gitlab.gnome.org/GNOME/sysprof.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif

%define glib_ver 2.76
%define gtk_ver 4.15.2
%define adw_ver 1.6
%define dex_ver 0.9
%define panel_ver 1.4
%define systemd_ver 222
%define polkit_ver 0.105

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson gcc-c++ yelp-tools
BuildRequires: desktop-file-utils  /usr/bin/appstreamcli
BuildRequires: glib2-devel >= %glib_ver libjson-glib-devel
BuildRequires: libdex-devel >= %dex_ver
BuildRequires: libdw-devel
BuildRequires: libdebuginfod-devel
BuildRequires: libpanel-devel >= %panel_ver
BuildRequires: gobject-introspection-devel
%{?_enable_gtk:BuildRequires: libgtk4-devel >= %gtk_ver pkgconfig(libadwaita-1) >= %adw_ver}
%{?_enable_sysprofd:BuildRequires: pkgconfig(systemd) libpolkit-devel >= %polkit_ver}
%{?_enable_libunwind:BuildRequires: libunwind-devel}


%description
The Sysprof profiler is a statistical profiler based on hardware
performance counters in modern CPUs. Please see %url for more
information.

%package devel
Summary: Development files for GtkHex
Group: Development/C
Requires: %name = %EVR

%description devel
The %name-devel package contains libraries and header files for
developing applications that use GtkGHex library.

%prep
%setup -n %name-%version%beta

%build
%meson \
    %{subst_enable_meson_bool gtk gtk} \
    %{?_enable_sysprofd:-Dsysprofd=bundled}
%meson_build

%install
%meson_install

%find_lang --with-gnome --output=%name.lang %name

%files -f %name.lang
%_bindir/%name-cli
%_bindir/%name
%_bindir/%name-agent
%_bindir/%name-cat
%_libexecdir/%name-live-unwinder
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*
%_libdir/lib%name-%api_ver.so.*
%_libdir/lib%name-memory-%api_ver.so
%_libdir/lib%name-speedtrack-%api_ver.so
%_libdir/lib%name-tracer-%api_ver.so

%if_enabled sysprofd
%_libexecdir/sysprofd
%_unitdir/sysprof3.service
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/system-services/%{xdg_name}%{service_ver}.service
%_datadir/dbus-1/system.d/%{xdg_name}%{service_ver}.conf
%_datadir/polkit-1/actions/org.gnome.sysprof%{service_ver}.policy

%_datadir/dbus-1/interfaces/%{xdg_name}%{service_ver}.Profiler.xml
%_datadir/dbus-1/interfaces/%{xdg_name}%{service_ver}.Service.xml
%_datadir/dbus-1/interfaces/%{xdg_name}.Agent.xml
%endif

%_datadir/mime/packages/%name-mime.xml
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc AUTHORS NEWS README*

%files devel
%_libdir/lib%name-capture-%capture_ver.a
%_libdir/lib%name-%api_ver.so
%_includedir/%{name}-%api_ver/
%_pkgconfigdir/%name-%api_ver.pc
%_pkgconfigdir/%name-capture-%capture_ver.pc

%changelog
