# vim: set ft=spec: -*- rpm-spec -*-
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define sover 2
Name: sysfsutils
Version: 2.1.1
Release: alt3
Summary: Utilities for interfacing with sysfs
Group: System/Kernel and hardware
License: GPL-2.0
Url: http://linux-diag.sourceforge.net/Sysfsutils.html
Vcs: https://github.com/linux-ras/sysfsutils
Requires: libsysfs%sover = %EVR

Source: %name-%version.tar
Source1: sysfs.conf
Source2: sysfs.init
Source3: sysfs.service

%{?!_without_check:%{?!_disable_check:
BuildRequires: systemd-analyze
}}

%package -n libsysfs%sover
Summary: Library for interfacing with sysfs
License: LGPL-2.1-or-later
Group: System/Libraries
Obsoletes: libsysfs < %EVR

%package -n libsysfs-devel
Summary: Headers for developing programs that will use libsysfs
License: LGPL-2.1-or-later
Group: Development/C
Requires: libsysfs%sover = %EVR

%description
This package's purpose is to provide a set of utilities for interfacing
with sysfs, a virtual filesystem in Linux kernel versions 2.5+ that
provides a tree of system devices.  While a filesystem is a very useful
interface, we've decided to provide a stable programming interface that
will hopefully make it easier for applications to query system devices
and their attributes.

%description -n libsysfs%sover
This package contains the library needed to run programs dynamically
linked with libsysfs.

%description -n libsysfs-devel
This package contains the headers that programmers will need to develop
applications which will use libsysfs.

%prep
%setup

%build
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static
%make_build

%install
mkdir -p %buildroot{/%_lib,%_sysconfdir,%_initdir,%_unitdir}

%makeinstall_std

v=`objdump -p %buildroot%_libdir/libsysfs.so |awk '/SONAME/ {print $2}'`
[ -n "$v" ]
mv -v %buildroot%_libdir/libsysfs.so.* %buildroot/%_lib
ln -sf "../../%_lib/$v" %buildroot%_libdir/libsysfs.so

install -p -m644 %_sourcedir/sysfs.conf %buildroot%_sysconfdir/sysfs.conf
install -p -m755 %_sourcedir/sysfs.init %buildroot%_initdir/sysfs
install -p -m644 %_sourcedir/sysfs.service %buildroot%_unitdir/sysfs.service
install -d -m755 %buildroot%_sysconfdir/sysfs.d

%check
bash -n %buildroot%_initdir/sysfs

# Only compiles examples but does not run them.
%make_build check

%post
%post_service sysfs

%preun
%preun_service sysfs

%files
%doc COPYING cmd/GPL
%config(noreplace) %_sysconfdir/sysfs.conf
%dir %_sysconfdir/sysfs.d
%_initdir/sysfs
%_unitdir/sysfs.service
%_bindir/*
%_man1dir/*.1*

%files -n libsysfs%sover
%doc AUTHORS CREDITS lib/LGPL
/%_lib/libsysfs.so.%sover
/%_lib/libsysfs.so.%sover.*

%files -n libsysfs-devel
%doc docs/*.txt TODO README
%_libdir/libsysfs.so
%_includedir/*
%_pkgconfigdir/libsysfs.pc

%changelog
