%define _unpackaged_files_terminate_build 1

%ifnarch ppc64le
%def_with check
%else
%def_without check
%endif

%def_without doc

Name: sympy
Epoch: 1
Version: 1.13.2
Release: alt2
Summary: A Python library for symbolic mathematics
License: BSD-3-Clause
Group: Sciences/Mathematics
Url: https://sympy.org/
VCS: https://github.com/sympy/sympy.git

BuildArch: noarch

Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata

Patch1: sympy-1.13.1-alt-build.patch

# https://github.com/sympy/sympy/pull/27069
Patch2: sympy-1.13.2-alt-fix-races-in-tests.patch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3-module-pytest-xdist
BuildRequires: dvipng ImageMagick-tools graphviz librsvg-utils

%if_with check
BuildRequires: python3-module-pytest python3-module-mpmath python3-module-numpy-testing python3-module-hypothesis
%endif

Requires: python3-module-%name = %EVR

%add_python3_req_skip py.__.test.item py.__.test.terminal.terminal

%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%endif

%description
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%package -n python3-module-%name
Summary: A Python 3 module for symbolic mathematics
Group: Development/Python3

%description -n python3-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python3-module-%name-examples
Summary: Examples for SymPy
Group: Development/Documentation
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-examples
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains examples for SymPy.

%package -n python3-module-%name-pickles
Summary: Pickles for SymPy
Group: Development/Python
Requires: python3-module-%name = %EVR

%description -n python3-module-%name-pickles
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains pickles for SymPy.

%package -n python3-module-%name-doc
Summary: Documentation for SymPy
Group: Development/Documentation
BuildArch: noarch

%description -n python3-module-%name-doc
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains development documentation for SymPy.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%patch1 -p1
%patch2 -p1

for i in $(find ./ -name tests); do
	touch $i/__init__.py
done

sed -i 's|@PYVER@|%_python3_version|g' doc/Makefile
%if_with doc
%prepare_sphinx3 .
%endif

%build
export LC_ALL=en_US.UTF-8
%pyproject_build

%if_with doc
pushd doc
%make html
popd

rm -fR doctrees
cp -fR doc/_build/doctrees doc/src/
export PYTHONPATH=$PYTHONPATH:$PWD
cp -fR doc/_build/doctrees ./

%generate_pickles3 $PWD $PWD/doc/_build/html %name
%endif

%install
%pyproject_install

%if_with doc
cp -fR pickle %buildroot%python3_sitelibdir/%name/
%endif

# remove tests files
%python3_prune
# by some reason sympy.testing is wide used in the project modules
#rm -rfv %buildroot%python3_sitelibdir/%name/testing/
rm -rfv %buildroot%python3_sitelibdir/%name/conftest.py
rm -rfv %buildroot%python3_sitelibdir/%name/utilities/{*test.py,_compilation/}
rm -rfv %buildroot%python3_sitelibdir/%name/parsing/autolev/test-examples/

%check
py.test-3 -vv -n %_smp_build_ncpus \
	--deselect=sympy/integrals/tests/test_failing_integrals.py::test_issue_15227 \
	--deselect=sympy/matrices/tests/test_matrices.py::test_pinv_rank_deficient_when_diagonalization_fails \
	--deselect=sympy/solvers/ode/tests/test_systems.py::test_linear_new_order1_type2_de_lorentz_slow_check \
	%nil

%if_with doc
python3 bin/doctest -v ||:
%endif

%files
%doc AUTHORS LICENSE README* CODE_OF_CONDUCT.md
%_bindir/*
%_man1dir/*

%files -n python3-module-%name
%python3_sitelibdir/*
%if_with doc
%exclude %python3_sitelibdir/%name/pickle
%endif

%files -n python3-module-%name-examples
%doc examples/*

%if_with doc
%files -n python3-module-%name-pickles
%python3_sitelibdir/%name/pickle

%files -n python3-module-%name-doc
%doc doc/_build/html/*
%endif

%changelog
