%def_with boost
%def_with caml
%def_with doc
#def_with java
%def_with lua
%def_with perl5
#def_with python
%def_with python3
#def_with R
%def_with ruby
%def_with scheme
%def_with tcl

# vim:set ft=spec:
Name: swig
Version: 4.3.1
Release: alt1
Epoch: 1

Summary: Simplified Wrapper and Interface Generator (SWIG)
License: Open Source
Group: Development/C
Url: https://github.com/swig/swig

# Source-url: https://github.com/swig/swig/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

# Revert https://github.com/swig/swig/commit/5755f399a2e6bd5203eb925a8d525501fec628ab
Patch1: revert-Eliminate-some-temporary-buffers.patch

# ALT commit 310d524062b544c538977c5e33548889fbb85926
Patch2: 0001-guile-first-arg-to-scm_error-should-be-symbol-not-st.patch

%ifnarch %ix86
%def_enable testsuite
%endif

%{?_with_boost:BuildRequires: boost-devel}
%{?_with_caml:BuildRequires: ocaml-findlib}
%{?_with_doc:BuildRequires: yodl tidy htmldoc}
%{?_with_java:BuildRequires: java-devel}
%{?_with_lua:BuildRequires: liblua5-devel lua5}
%{?_with_perl5:BuildRequires: perl-devel libpcre2-devel}
%{?_with_python:BuildRequires: python-devel}
%{?_with_python3:BuildRequires: rpm-build-python3 python3-devel python-tools-2to3}
%{?_with_R:BuildRequires: R-devel}
%{?_with_ruby:BuildRequires: libruby-devel ruby}
%{?_with_scheme:BuildRequires: chicken guile22-devel}
%{?_with_tcl:BuildRequires: tcl-devel}

BuildRequires: gcc-c++
BuildRequires: libXt-devel imake xorg-cf-files
BuildRequires: zlib-devel

%if_enabled testsuite
BuildRequires: perl(Math/BigInt.pm)
%endif

Provides: %name-devel = %version
Obsoletes: %name-deve
Obsoletes: %name-runtime-guile   %name-runtime-python  %name-runtime-perl  %name-runtime-ruby  %name-runtime-tcl
Requires: %name-data = %EVR

%package data
BuildArch: noarch
Summary: SWIG data files
Group: Development/C
Conflicts: %name < %EVR

%package doc
BuildArch: noarch
Summary: SWIG documentation
Group: Books/Other
Requires: %name = %EVR

%package runtime-guile
Group: System/Libraries
Summary: SWIG runtime guile library

%package runtime-perl
Group: System/Libraries
Summary: SWIG runtime perl library
Requires: %name = %EVR

%package runtime-python
Group: System/Libraries
Summary: SWIG runtime python library

%package runtime-ruby
Group: System/Libraries
Summary: SWIG runtime ruby library

%package runtime-tcl
Group: System/Libraries
Summary: SWIG runtime tcl library

%description
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

%description doc
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG documentation.

%description data
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG data files.

%description runtime-guile
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime guile library.

%description runtime-perl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime perl library.

%description runtime-python
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime python library.

%description runtime-ruby
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime ruby library.

%description runtime-tcl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime tcl library.

%prep
%setup
%autopatch -p1

%build
./autogen.sh
sed -i 's/PYLIBDIR="lib"/PYLIBDIR="%_lib"/' configure
sed -i 's/PY3LIBDIR="lib"/PY3LIBDIR="%_lib"/' configure
%configure \
	%{?_with_python:--with-python=python} \
	%{?_with_python3:--with-python3=python3} \
	%{?_with_caml:--with-ocamlc=ocamlc} \
	%{subst_with boost} \
	%{subst_with java} \
	%{subst_with perl5} \
	%{subst_with ruby} \
	%{subst_with tcl} \
	--with-pyinc=%_includedir/python%_python3_version \
	--with-pylib=%_libdir/python%_python3_version \
	--with-tclconfig=%_libdir
	#--with-tcl --with-python --with-perl5 --with-java --with-guile --with-ruby

#%__subst -p 's,/usr/local/include/Py,%_includedir/python%__python_version,g' Runtime/Makefile
# SMP incompatible
# no `all' target
%make_build
#%make docs
#%make runtime
#pushd Runtime
#%make
#popd
xz -9fk CHANGES TODO

%install
%makeinstall_std \
	M4_INSTALL_DIR=%buildroot%_datadir/aclocal
mkdir -p %buildroot%_includedir
cp -aL Source/Swig/*.h Source/DOH/*.h Source/Include/*.h \
	%buildroot%_includedir/
# symlinks
#__rm -fv Examples/perl Examples/test-suite/perl Examples/GIFPlot/Php4

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 ANNOUNCE CHANGES* COPYRIGHT LICENSE* README RELEASENOTES TODO* \
	%buildroot%docdir/
cp -a Examples Doc %buildroot%docdir/

#pushd Runtime
#%make_install install DESTDIR=%buildroot
#popd

%if_enabled testsuite
%check
%__make check PY3=1
%endif

%files
%_bindir/*
#%_datadir/aclocal/%name.m4
%_includedir/*
%dir %docdir
%docdir/[A-Z][A-Z]*

%files doc
%dir %docdir
%docdir/[A-Z][a-z]*
#%_man1dir/*

%files data
%_datadir/%{name}

#%files runtime-guile
#%_libdir/libswigguile*.so*
#%doc CHANGES.current LICENSE

#files runtime-perl
#_libdir/libswigpl*.so*
#doc CHANGES.current LICENSE

#%files runtime-python
#%_libdir/libswigpy*.so*
#%doc CHANGES.current LICENSE

#%files runtime-ruby
#%_libdir/libswigrb*.so*
#%doc CHANGES.current LICENSE

#%files runtime-tcl
#%_libdir/libswigtcl*.so*
#%doc CHANGES.current LICENSE

%changelog
