%define        _unpackaged_files_terminate_build 1
%def_disable   check
%define        nomen swipl

Name:          swi-prolog
Version:       9.3.25.39
Release:       alt0.2
Summary:       Prolog interpreter and compiler
License:       BSD-2-Clause
Group:         Development/Other
Url:           http://www.swi-prolog.org
Vcs:           https://github.com/SWI-Prolog/swipl-devel.git

Source:        %name-%version.tar

BuildRequires(pre): rpm-build-cmake
BuildRequires: cmake
BuildRequires: gcc-c++
BuildRequires: libgmp-devel
BuildRequires: libncurses-devel
BuildRequires: libreadline-devel
BuildRequires: libssl-devel
BuildRequires: zlib-devel
%if_enabled    check
BuildRequires: ctest
%endif

%add_findreq_skiplist %_libexecdir/swipl/**/*
%add_findprov_skiplist %_libexecdir/swipl/**/*

%description
Edinburgh-style Prolog compiler including modules, autoload, libraries,
Garbage-collector, stack-expandor, C-interface, GNU-readline and GNU-Emacs
interface, very fast compiler.


%package       -n lib%nomen
Group:         Development/Other
Summary:       SWI-Prolog libraries

%description   -n lib%nomen
SWI-Prolog libraries.

Edinburgh-style Prolog compiler including modules, autoload, libraries,
Garbage-collector, stack-expandor, C-interface, GNU-readline and GNU-Emacs
interface, very fast compiler.


%package       -n lib%nomen-devel
Group:         Development/Other
Summary:       SWI-Prolog libraries development module

Requires:      cmake
Requires:      gcc-c++
Requires:      libgmp-devel
Requires:      libncurses-devel
Requires:      libreadline-devel
Requires:      libssl-devel
Requires:      zlib-devel
Requires:      ctest

%description   -n lib%nomen-devel
SWI-Prolog libraries development module.

Edinburgh-style Prolog compiler including modules, autoload, libraries,
Garbage-collector, stack-expandor, C-interface, GNU-readline and GNU-Emacs
interface, very fast compiler.


%package       -n %nomen
Group:         Development/Other
Summary:       SWI-Prolog interpreter and compiler
Provides:      swi-prolog = %EVR
Obsoletes:     swi-prolog < %EVR

%description   -n %nomen
SWI-Prolog interpreter and compiler.

Edinburgh-style Prolog compiler including modules, autoload, libraries,
Garbage-collector, stack-expandor, C-interface, GNU-readline and GNU-Emacs
interface, very fast compiler.


%package       -n %nomen-stdlib
Group:         Development/Other
Summary:       SWI-Prolog standard scripts

%description   -n %nomen-stdlib
SWI-Prolog standard scripts.

Edinburgh-style Prolog compiler including modules, autoload, libraries,
Garbage-collector, stack-expandor, C-interface, GNU-readline and GNU-Emacs
interface, very fast compiler.


%prep
%setup

%ifarch loongarch64 riscv64
# try_compile with CMAKE_TRY_COMPILE_TARGET_TYPE set to STATIC_LIBARY
# does not seem to be compatible with LTO. However, currently this
# seems to break only loongarch64 and riscv64 builds
sed -i '/CMAKE_TRY_COMPILE_TARGET_TYPE.*STATIC_LIBRARY/d' cmake/*.cmake
%endif

%build
%cmake \
   -DCMAKE_BUILD_TYPE=RelWithDebInfo \
   -DCMAKE_EXECUTABLE_FORMAT=ELF \
   -DCMAKE_SKIP_BUILD_RPATH=ON \
   -DCMAKE_INSTALL_LIBDIR=lib%_libsuff \
   -DWARN_NO_DOCUMENTATION=ON \
   -DINSTALL_DOCUMENTATION=ON \
   -DSWIPL_ARCH=%_arch \
   -DSWIPL_SHARED_LIB=ON \
   -DSWIPL_VERSIONED_DIR=OFF \
   -DSWIPL_INSTALL_IN_SHARE=OFF \
   -DSWIPL_PACKAGES=OFF \
   -DSWIPL_INSTALL_PREFIX=lib/%nomen \
   -DSWIPL_INSTALL_ARCH_EXE=lib%_libsuff/%nomen/bin \
   -DSWIPL_INSTALL_ARCH_LIB=lib%_libsuff/%nomen \
   -DSWIPL_INSTALL_CMAKE_CONFIG_DIR=lib%_libsuff/cmake/swipl \
   -DSWIPL_INSTALL_PKGCONFIG=lib%_libsuff/pkgconfig \
   -DSWIPL_INSTALL_IN_LIB=ON \
   -DMULTI_THREADED=ON \
   -DBUILD_TESTING=ON \
   %nil
%cmake_build

%install
%cmake_install

%check
%ctest

%files         -n %nomen
%doc README.md LICENSE VERSION
%_bindir/%{nomen}*
%_man1dir/%{nomen}*

%files         -n %nomen-stdlib
%doc README.md LICENSE VERSION
%_libexecdir/swipl
%_libdir/swipl

%files         -n lib%nomen
%_libdir/lib%{nomen}.so.*

%files         -n lib%nomen-devel
%doc README.md LICENSE VERSION
%_libdir/lib%{nomen}.so
%_libdir/cmake/swipl
%_pkgconfigdir/swipl.pc


%changelog
