%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

Name: supertuxkart
Version: 1.5
Release: alt1

Summary: SuperTuxKart is a kart racing game

License: GPL-2.0-or-later and GPL-3.0-or-later and CC-BY-SA-3.0
Group: Games/Arcade
Url: https://supertuxkart.sourceforge.net
Vcs: https://github.com/supertuxkart/stk-code

Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version-src.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-ninja
# for aarch64 support
BuildRequires(pre): libGLES
# Automatically added by buildreq on Thu Jan 30 2020 (-bi)
# optimized out: bash4 bashrc cmake-modules elfutils glibc-kernheaders-generic glibc-kernheaders-x86 libGLU-devel libICE-devel libSM-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libXrender-devel libcrypt-devel libglvnd-devel libharfbuzz-devel libogg-devel libsasl2-3 libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl pkg-config python-modules python2-base python3 python3-base rpm-build-gir sh4 tzdata wayland-devel xorg-proto-devel xorg-xf86miscproto-devel zlib-devel
BuildRequires: bzlib-devel cmake gcc-c++ libGLEW-devel libXi-devel libXrandr-devel libXt-devel libXxf86misc-devel libXxf86vm-devel libcurl-devel libfreetype-devel libfribidi-devel libjpeg-devel libopenal-devel libpng-devel libsqlite3-devel libssl-devel libvorbis-devel libwayland-cursor-devel libwayland-egl-devel libxkbcommon-devel libxkbfile-devel poppler rpm-build-python3 libSDL2-devel libmcpp-devel libshaderc-devel
# display results online or connect directly to hubzilla or connect to a game launcher
BuildRequires: libgamerzilla-devel
# use system libraries instead build-in
BuildRequires: libwiiuse-devel libraqm-devel libangelscript-devel

Requires: %name-data >= %version

%description
SuperTuxCart is a kart racing game

%prep
%setup -n %name-%version
%patch -p1

sed -i 's|#!/usr/bin/env python3|#!%__python3|' \
    $(find ./ -name '*.py')
sed -i 's|#!/usr/bin/env python|#!%__python3|' \
    $(find ./ -name '*.py')

%build
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DUSE_SYSTEM_ANGELSCRIPT=ON \
    -DBUILD_RECORDER=OFF \
    -DCHECK_ASSETS=OFF \
    -DNO_SHADERC=OFF \
#
cmake --build %_cmake__builddir -j%__nprocs

%install
#install -d %%buildroot%%_niconsdir
%cmake_install

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories
# usually don't belong in releases.
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find %buildroot -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# the find below is useful in case those CVS/.svn/.git/.hg/.bzr/_MTN directory is added as %%doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# built in separate libwiiuse-devel
rm -f %buildroot%_libdir/libwiiuse.a
rm -f %buildroot%_includedir/wiiuse.h
rm -f %buildroot%_datadir/%name/data/optimize_data.sh

%files
%doc README.md CHANGELOG.md NETWORKING.md
%_bindir/*
%_desktopdir/%name.desktop
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/metainfo/*
# %%_pixmapsdir/*
%_iconsdir/hicolor/16x16/apps/*
%_iconsdir/hicolor/32x32/apps/*
%_iconsdir/hicolor/48x48/apps/*
%_iconsdir/hicolor/64x64/apps/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/256x256/apps/*
%_iconsdir/hicolor/512x512/apps/*
%_iconsdir/hicolor/1024x1024/apps/*

%changelog
