Name: supertux2
Version: 0.6.3
Release: alt3

Summary: Classic 2D jump'n run sidescroller game in a Super Mario style
License: GPL-3.0-or-later AND CC-BY-SA-3.0 AND GPL-2.0-or-later AND GPL-1.0-only
Group: Games/Arcade

Url: https://www.supertux.org/

# Source-url: https://github.com/SuperTux/supertux/releases/download/v%version/SuperTux-v%version-Source.tar.gz
Source: SuperTux-v%version-Source.tar.gz

Source1: supertux-16x16.png
Source2: supertux-32x32.png
Source3: supertux-48x48.png

Patch: supertux2-0.6.3-alt-gcc12.patch

Packager: Anton Midyukov <antohami@altlinux.org>

Requires: %name-data = %version-%release

# Automatically added by buildreq on Mon Oct 01 2012 (-bi)
# WTF? vorbis-tools? really?
BuildPreReq: cmake rpm-macros-cmake rpm-build-ninja doxygen
BuildRequires: boost-program_options-devel boost-filesystem-devel boost-locale-devel gcc-c++ libSDL2_image-devel libSM-devel libXau-devel libXdmcp-devel libXft-devel libcurl-devel libglew-devel libopenal-devel libphysfs-devel libvorbis-devel zlib-devel libpng-devel libfreetype-devel libraqm-devel libfribidi-devel libglm-devel

%description
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below.  Grabbing power-ups and other stuff
on the way.

Note! This is a still development version.

%package data
Summary: Data files for supertux2
Group: Games/Arcade
BuildArch: noarch

%description data
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below. Grabbing power-ups and other stuff
on the way.

This is package contains data files for supertux2.

%prep
%setup -n SuperTux-v%version-Source
%patch -p2

%ifarch %e2k
# see also http://github.com/albertodemichelis/squirrel/pull/226/commits
# (thx Ramil Sattarov for the reference)
sed -i 's/LINKER_LANGUAGE C/&XX/' external/squirrel/sq/CMakeLists.txt
%endif

%build
# cmake 4
# EMSCRIPTEN and VCPKG_BUILD do not used by the project
export CMAKE_POLICY_VERSION_MINIMUM=3.5
%cmake_insource \
        -GNinja \
        -DINSTALL_SUBDIR_BIN=bin \
        -DINSTALL_SUBDIR_SHARE=share/supertux2 \
        -DCMAKE_BUILD_TYPE="Release" \
        -DENABLE_BOOST_STATIC_LIBS=OFF
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
%find_lang %name

install -pDm644 %SOURCE1 %buildroot/%_miconsdir/%name.png
install -pDm644 %SOURCE2 %buildroot/%_niconsdir/%name.png
install -pDm644 %SOURCE3 %buildroot/%_liconsdir/%name.png

# install game man file
install -pDm644 man/man6/%name.6 %buildroot/%_man6dir/%name.6

rm -rf %buildroot/%_docdir/supertux2/

%files -f %name.lang
%_bindir/supertux2
%_desktopdir/supertux2.desktop
%doc LICENSE.txt NEWS.md README.md

%files data
%_datadir/supertux2
%_datadir/metainfo/*
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png
%dir %_iconsdir/hicolor/scalable
%dir %_iconsdir/hicolor/scalable/apps
%_iconsdir/hicolor/scalable/apps/*
%exclude %_pixmapsdir/supertux.*
%_man6dir/*
%exclude %_datadir/supertux2/sounds/normalize.sh

%changelog
