Name: stlink
Version: 1.8.0
Release: alt1
Epoch: 1

Summary: STM32 microcontrolles programmer and debuger, using STLINKv1/v2/v2-1/v3
License: BSD-3-Clause
Group: Development/Other
Url: https://github.com/stlink-org/stlink

Conflicts: stlink-gui < 1.8.0

Source0: %name-%version.tar
Patch0: Post-release-patch-for-v1.8.0.patch

BuildRequires: cmake
BuildRequires: libgtk+3-devel
BuildRequires: libusb-devel
BuildRequires: pandoc

%description

Open source version of the STMicroelectronics STlink Tools

STLink is an open source toolset to program and debug STM32 devices and boards
manufactured by STMicroelectronics. It supports several so called STLINK
programmer boards (and clones thereof) which use a microcontroller chip to
translate commands from USB to JTAG/SWD. There are four generations available
on the market which are all supported by this toolset:

 STLINK/v1 (obsolete as of 21-11-2019, continued support by this toolset)
   transport layer: SCSI passthru commands over USB
   stand-alone programmer and present on STM32VL Discovery boards
 STLINK/v2
   transport layer: raw USB commands
   stand-alone programmer and present on STM32L Discovery and Nucleo boards
 STLINK/v2-1
   transport layer: raw USB commands
   present on some STM32 Nucleo boards
 STLINK/v3
   transport layer: raw USB commands
   stand-alone programmer

On the user level there is no difference in handling or operation between these
different revisions.

%package -n lib%name
Summary: Shared library of %name
Group: System/Libraries

%description -n lib%name
Lib files for stlink

%package -n lib%name-devel
Summary: Development files of %name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Development files for libstlink

%package gui
Summary: GUI for %name
Group: Development/Other
Requires: %name = %EVR

%description gui
GUI for stlink

%prep
%setup
%patch0 -p1
# no need to set it explicitly
sed -i '/("-D_FORTIFY_SOURCE=2")/d' cmake/modules/c_flags.cmake
echo %version > .version

%build
%cmake \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DINCLUDE_INSTALL_DIR=%_includedir \
	-DSTLINK_GENERATE_MANPAGES=ON \
	-DSTLINK_UDEV_RULES_DIR=%_udevrulesdir \
	-DSTLINK_MODPROBED_DIR=%_modprobedir

%cmake_build -j1

%install
%cmakeinstall_std
rm -v %buildroot/%_libdir/lib%name.a
# upstream dropped pc generator altogether
mkdir -p %buildroot%_pkgconfigdir
cat > %buildroot%_pkgconfigdir/stlink.pc << 'E_O_F'
prefix=%_prefix
exec_prefix=%_prefix
libdir=%_libdir
includedir=%_includedir

Name: stlink
Description: STLINK library
Version: %version
Libs: -lstlink
Cflags: -I${includedir}/stlink
E_O_F

%files
%doc CHANGELOG.md LICENSE.md README.md
%_modprobedir/*
%_udevrulesdir/*
%_bindir/st-*
%_datadir/stlink
%exclude %_datadir/stlink/stlink-gui.ui
%_man1dir/*

%files gui
%_bindir/stlink-gui
%_datadir/stlink/stlink-gui.ui
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.svg

%files -n lib%name
%_libdir/libstlink.so.*

%files -n lib%name-devel
%_includedir/stlink
%_libdir/libstlink.so
%_pkgconfigdir/stlink.pc

%changelog
