%def_disable clang

Name: startdde
Version: 6.1.6
Release: alt3
Epoch: 1

Summary: Starter of deepin desktop environment

License: GPL-3.0+
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/startdde
Vcs: https://github.com/linuxdeepin/startdde.git

Source0: %url/archive/%version/%name-%version.tar.gz
Source1: vendor.tar
Patch: %name-%version-%release.patch

%if_enabled clang
BuildRequires(pre): clang-devel
%else
BuildRequires(pre): gcc-c++
%endif
BuildRequires(pre): rpm-build-golang /proc
BuildRequires: glib2-devel libgio-devel libgtk+3-devel libXcursor-devel libXfixes-devel libXi-devel libgudev-devel libgnome-keyring-devel libpulseaudio-devel libalsa-devel libsecret-devel

%description
Startdde is used for launching DDE components and invoking user's custom applications which compliant with xdg autostart specification.

%prep
%setup -a1
%autopatch -p1

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
export AR="llvm-ar"
%endif
export GOPATH="$(pwd)/vendor:%go_path"
%make

%install
export GOPATH="%go_path"
%makeinstall DESTDIR=%buildroot
# fix conflicts with deepin-daemon 6.1.44
rm -rf %buildroot%_libexecdir/deepin-daemon/
rm -rf %buildroot%_datadir/glib-2.0/schemas/com.deepin.dde.display.gschema.xml
rm -rf %buildroot%_userunitdir/dde-display-task-refresh-brightness.service
rm -rf %buildroot%_userunitdir/dde-session-initialized.target.wants/
rm -rf %buildroot%_datadir/lightdm/lightdm.conf.d/60-deepin.conf
# package localization files
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_sbindir/deepin-fix-xauthority-perm
%dir %_datadir/%name/
%_datadir/%name/filter.conf
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.startdde/
%dir %_datadir/dsg/configs/org.deepin.startdde/org.deepin.XSettings.json
%dir %_datadir/dsg/configs/org.deepin.startdde/org.deepin.Display.json

%changelog
