%ifarch i586 armh ppc64le
%def_without check
%else
%def_with check
%endif

Name: starship
Version: 1.24.1
Release: alt2
Summary: The minimal, blazing-fast, and infinitely customizable prompt for any shell
License: ISC
Group: Shells
Url: https://starship.rs
VCS: https://github.com/starship/starship

Source: %name-%version.tar
Source1: vendor.tar

BuildRequires(pre): rpm-macros-rust
BuildRequires: rpm-build-rust
BuildRequires: cargo-vendor-checksum
BuildRequires: cmake

%if_with check
BuildRequires: git
%endif

%description
%summary.

%prep
%setup -a 1
%rust_prep
sed -i 's/strip = true/strip = false/' Cargo.toml
%ifarch armh i586
# build failed with lto
sed -i 's/lto = true/lto = false/' Cargo.toml
%endif

%build
cargo-vendor-checksum --all
%rust_build

%install
%rust_install

%check
%buildroot%_bindir/%name print-config > %name.toml
export STARSHIP_CONFIG=%name.toml
export TERM=xterm
# skip randomly failing test
cargo test -- --skip expiration_date_set

%files
%_bindir/%name
%doc LICENSE

%changelog
