Name: sslh
Version: 2.1.4
Release: alt1

Summary: A ssl/ssh multiplexer

License: GPLv2
Group: System/Servers
Url: http://www.rutschle.net/tech/sslh.shtml

# Source-url: https://github.com/yrutschle/sslh/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

Source1: sslh.init
Source2: sslh.config
Source3: sslh.service
Source4: sslh.cfg

# Automatically added by buildreq on Sun Aug 29 2021
BuildRequires: libcap-devel libconfig-devel libpcre2-devel libsystemd-devel libev-devel perl-Pod-Parser

%description
sslh lets one accept both HTTPS and SSH connections on the
same port. It makes it possible to connect to an SSH server
on port 443 (e.g. from inside a corporate firewall) while
still serving HTTPS on that port.

%prep
%setup

%build
%configure
%make_build USELIBCONFIG=1 USESYSTEMD=1 USELIBCAP=1 CFLAGS="%optflags -I%_includedir/pcre"

%install
%makeinstall PREFIX=%buildroot%prefix
install -D -m 644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -D -m 755 %SOURCE1 %buildroot%_initdir/%name
install -D -m 644 %SOURCE3 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sysconfdir/%name/
install -m 644 %SOURCE4 %buildroot%_sysconfdir/%name/sslh.cfg

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.md
%_man8dir/sslh.8.*
%_sbindir/sslh
%_unitdir/%name.service
%config(noreplace) %_initdir/sslh
%config(noreplace) %_sysconfdir/sysconfig/%name
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/sslh.cfg

%changelog
