%define spawn_fcgi_user _spawn_fcgi
%define spawn_fcgi_group _spawn_fcgi

Name: spawn-fcgi
Version: 1.6.6
Release: alt1

Summary: spawn FastCGI applications
License: BSD
Group: System/Servers

Url: https://redmine.lighttpd.net/projects/spawn-fcgi/wiki
VCS: https://github.com/lighttpd/spawn-fcgi
Source0: %name-%version.tar
Patch0: %name-%version-alt.patch
BuildRequires: meson

%description
  spawn-fcgi is used to spawn FastCGI applications

  Features
  --------
  - binds to IPv4/IPv6 and Unix domain sockets
  - supports privilege separation: chmod/chown socket, drop to uid/gid
  - supports chroot
  - supports daemontools supervise

%prep
%setup
%patch0 -p1

%build
%meson
%meson_build

%install
%meson_install

%check
%meson_test

install -pDm755 altlinux/spawn-fcgi.init %buildroot%_initdir/spawn-fcgi
install -pDm644 altlinux/spawn-fcgi.sysconfig %buildroot%_sysconfdir/sysconfig/spawn-fcgi

mkdir -p %buildroot/%_tmpfilesdir/
cat <<EOF >%buildroot/%_tmpfilesdir/%name.conf
d %_runtimedir/%name 1770 root %spawn_fcgi_group
EOF


%pre
%_sbindir/groupadd -r -f %spawn_fcgi_group ||:
%_sbindir/useradd -r -g %spawn_fcgi_group -d /dev/null -s /dev/null -N %spawn_fcgi_user \
        2> /dev/null > /dev/null ||:

%files
%_bindir/spawn-fcgi
%_man1dir/spawn-fcgi*
%config(noreplace) %_sysconfdir/sysconfig/spawn-fcgi
%config(noreplace) %_tmpfilesdir/%name.conf
%_initdir/spawn-fcgi

%changelog
